/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.xml;

import cn.ponfee.commons.xml.XmlReader;
import cn.ponfee.commons.xml.XmlWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlMap
extends LinkedHashMap<String, String> {
    private static final long serialVersionUID = 2775335692799838871L;
    private String root;

    public XmlMap(Map<String, String> map) {
        this(map, "xml");
    }

    public XmlMap(Map<String, String> map, String root) {
        this.root = root;
        super.putAll(map);
    }

    public XmlMap(String xml) {
        Map<Object, Object> map = StringUtils.isEmpty((CharSequence)xml) ? Collections.emptyMap() : this.read(XmlReader.create(xml));
        super.putAll(map);
    }

    public XmlMap(XmlReader reader) {
        super.putAll(this.read(reader));
    }

    public Map<String, String> toMap() {
        return this;
    }

    public String toXml() {
        XmlWriter writers = XmlWriter.create();
        for (Map.Entry param : this.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)param.getValue()))) continue;
            writers.element((String)param.getKey(), (String)param.getValue());
        }
        return writers.build(this.root);
    }

    private Map<String, String> read(XmlReader reader) {
        NodeList children;
        this.root = reader.getRoot();
        Node rootNode = reader.getNode(this.root);
        if (rootNode == null || (children = rootNode.getChildNodes()).getLength() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> data = new HashMap<String, String>(children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (3 == n.getNodeType()) continue;
            data.put(n.getNodeName(), n.getTextContent());
        }
        return data;
    }
}

