/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.collect;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 3943991140850259837L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile int maxSize;

    public LRUCache() {
        this(1024);
    }

    public LRUCache(int maxCapacity) {
        super(16, 0.75f, true);
        this.maxSize = maxCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    @Override
    public boolean containsKey(Object key) {
        this.lock.readLock().lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public V get(Object key) {
        this.lock.readLock().lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.lock.writeLock().lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

