/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.collect;

import cn.ponfee.commons.collect.Comparators;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ValueSortedMap<K, V>
extends TreeMap<K, V> {
    private static final long serialVersionUID = -6242175050718596776L;

    private ValueSortedMap(Map<? extends K, ? extends V> map, Comparator<? super V> comparator) {
        super(new MapValueComparator(map, comparator));
        map.forEach((x$0, x$1) -> super.put(x$0, x$1));
    }

    public static <K, V extends Comparable<? super V>> ValueSortedMap<K, V> nullsFirst(Map<? extends K, ? extends V> map) {
        return ValueSortedMap.nullsFirst(map, Comparators.asc());
    }

    public static <K, V> ValueSortedMap<K, V> nullsFirst(Map<? extends K, ? extends V> map, Comparator<? super V> comparator) {
        return new ValueSortedMap<K, V>(map, Comparator.nullsFirst(comparator));
    }

    public static <K, V extends Comparable<? super V>> ValueSortedMap<K, V> nullsLast(Map<? extends K, ? extends V> map) {
        return ValueSortedMap.nullsLast(map, Comparators.asc());
    }

    public static <K, V> ValueSortedMap<K, V> nullsLast(Map<? extends K, ? extends V> map, Comparator<? super V> comparator) {
        return new ValueSortedMap<K, V>(map, Comparator.nullsLast(comparator));
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    private static class MapValueComparator<K, V>
    implements Comparator<K> {
        private final Map<? extends K, ? extends V> data;
        private final Comparator<? super V> comparator;

        private MapValueComparator(Map<? extends K, ? extends V> data, Comparator<? super V> comparator) {
            this.data = data;
            this.comparator = comparator;
        }

        @Override
        public int compare(K k1, K k2) {
            int n = this.comparator.compare(this.data.get(k1), this.data.get(k2));
            return n != 0 ? n : k1.toString().compareTo(k2.toString());
        }
    }
}

