/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.concurrent;

import cn.ponfee.commons.model.ToJsonString;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolMonitor
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 3890678647435855868L;
    private final long keepAliveTime;
    private final int corePoolSize;
    private final int maximumPoolSize;
    private final int largestPoolSize;
    private final int poolSize;
    private final long taskCount;
    private final long completedTaskCount;
    private final int queueSize;
    private final int activeCount;
    private final boolean shutdown;
    private final boolean terminated;

    public ThreadPoolMonitor(ThreadPoolExecutor pool) {
        this.keepAliveTime = pool.getKeepAliveTime(TimeUnit.MILLISECONDS);
        this.corePoolSize = pool.getCorePoolSize();
        this.maximumPoolSize = pool.getMaximumPoolSize();
        this.largestPoolSize = pool.getLargestPoolSize();
        this.poolSize = pool.getPoolSize();
        this.taskCount = pool.getTaskCount();
        this.completedTaskCount = pool.getCompletedTaskCount();
        this.queueSize = pool.getQueue().size();
        this.activeCount = pool.getActiveCount();
        this.shutdown = pool.isShutdown();
        this.terminated = pool.isTerminated();
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public long getTaskCount() {
        return this.taskCount;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

