/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.constrain;

import cn.ponfee.commons.base.PrimitiveTypes;
import cn.ponfee.commons.base.tuple.Tuple2;
import cn.ponfee.commons.constrain.Constraint;
import cn.ponfee.commons.model.Result;
import cn.ponfee.commons.model.ResultCode;
import cn.ponfee.commons.reflect.Fields;
import cn.ponfee.commons.reflect.GenericUtils;
import cn.ponfee.commons.util.ObjectUtils;
import cn.ponfee.commons.util.RegexUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FieldValidator.class);
    static final int MAX_MSG_SIZE = 500;
    private static final String CFG_ERR = "\u7ea6\u675f\u914d\u7f6e\u9519\u8bef[";
    private static final String EMPTY = "";
    static final Cache<Method, String[]> METHOD_ARGSNAME = CacheBuilder.newBuilder().build();
    private static final Cache<Tuple2<?, ?>, Pair<Boolean, String>> META_CFG_CACHE = CacheBuilder.newBuilder().build();

    protected FieldValidator() {
    }

    public static FieldValidator newInstance() {
        return new FieldValidator();
    }

    public final void constrain(Object bean) {
        Class<?> clazz = bean.getClass();
        if (clazz.isInterface()) {
            throw new UnsupportedOperationException("unsupported interface constrain.");
        }
        StringBuilder builder = new StringBuilder();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                Constraint cst = field.getAnnotation(Constraint.class);
                if (cst == null || Modifier.isStatic(field.getModifiers())) continue;
                builder.append(this.constrain(clazz, field.getName(), Fields.get(bean, field), cst, GenericUtils.getFieldActualType(clazz, field)));
            }
            clazz = clazz.getSuperclass();
        }
        if (builder.length() > 0) {
            throw new IllegalArgumentException(builder.toString());
        }
    }

    protected Object processError(StringBuilder errorMsgBuilder, Method method, Object[] args) {
        if (errorMsgBuilder.length() > 500) {
            errorMsgBuilder.setLength(497);
            errorMsgBuilder.append("...");
        }
        String errMsg = errorMsgBuilder.toString();
        if (LOG.isInfoEnabled()) {
            LOG.info("[args check not pass]-[{}]-{}-[{}]", new Object[]{method.toGenericString(), ObjectUtils.toString(args), errMsg});
        }
        return this.handleFailure(method.getReturnType(), errMsg);
    }

    protected Object handleFailure(Class<?> returnType, String errMsg) {
        if (returnType == Result.class) {
            return Result.failure(ResultCode.BAD_REQUEST.getCode(), errMsg);
        }
        throw new IllegalArgumentException(errMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String constrain(GenericDeclaration classOrMethod, String field, Object value, Constraint cst, Class<?> type) {
        Tuple2<GenericDeclaration, String> key = Tuple2.of(classOrMethod, field);
        Pair result = (Pair)META_CFG_CACHE.getIfPresent(key);
        if (result == null) {
            Cache<Tuple2<?, ?>, Pair<Boolean, String>> cache = META_CFG_CACHE;
            synchronized (cache) {
                result = (Pair)META_CFG_CACHE.getIfPresent(key);
                if (result == null) {
                    try {
                        this.verifyMeta(field, cst, type);
                        result = ImmutablePair.of((Object)true, null);
                        META_CFG_CACHE.put(key, (Object)result);
                    }
                    catch (Exception e) {
                        result = ImmutablePair.of((Object)false, (Object)e.getMessage());
                        META_CFG_CACHE.put(key, (Object)result);
                        throw e;
                    }
                }
            }
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            throw new UnsupportedOperationException((String)result.getRight());
        }
        return this.verifyValue(field, value, cst);
    }

    protected final String constrain(String name, Object value, Constraint cst, Class<?> type) {
        this.verifyMeta(name, cst, type);
        return this.verifyValue(name, value, cst);
    }

    private void verifyMeta(String name, Constraint c, Class<?> type) {
        if (type == null) {
            return;
        }
        type = PrimitiveTypes.ofPrimitive(type).wrapper();
        if ((StringUtils.isNotBlank((CharSequence)c.regExp()) || StringUtils.isNotBlank((CharSequence)c.datePattern()) || c.notBlank() || c.maxLen() > -1 || c.minLen() > -1) && !CharSequence.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException(CFG_ERR + name + "]\uff1a\u975e\u5b57\u7b26\u7c7b\u578b\u4e0d\u652f\u6301\u5b57\u7b26\u89c4\u5219\u9a8c\u8bc1");
        }
        if (!(c.max() == Long.MAX_VALUE && c.min() == Long.MIN_VALUE || Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type))) {
            throw new UnsupportedOperationException(CFG_ERR + name + "]\uff1a\u975e\u6574\u6570\u7c7b\u578b\u4e0d\u652f\u6301\u6574\u6570\u6570\u503c\u9a8c\u8bc1");
        }
        if (c.series() != null && c.series().length > 0 && !Long.class.isAssignableFrom(type) && !Integer.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException(CFG_ERR + name + "]\uff1a\u975e\u6574\u6570\u7c7b\u578b\u4e0d\u652f\u6301\u6570\u5217\u9a8c\u8bc1");
        }
        if (!(c.decimalMax() == Double.POSITIVE_INFINITY && c.decimalMin() == Double.NEGATIVE_INFINITY || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type))) {
            throw new UnsupportedOperationException(CFG_ERR + name + "]\uff1a\u975e\u6d6e\u70b9\u6570\u7c7b\u578b\u4e0d\u652f\u6301\u6d6e\u70b9\u6570\u503c\u9a8c\u8bc1");
        }
        if (c.tense() != Constraint.Tense.ANY && StringUtils.isBlank((CharSequence)c.datePattern()) && !Date.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException(CFG_ERR + name + "]\uff1a\u975e\u65e5\u671f\u7c7b\u578b\u4e0d\u652f\u6301\u65f6\u6001\u9a8c\u8bc1");
        }
        if (c.notEmpty() && !this.isEmptiable(type)) {
            throw new UnsupportedOperationException(CFG_ERR + name + "\u975e\u96c6\u5408/\u5b57\u7b26\u7c7b\u578b\u4e0d\u652f\u6301\u975e\u7a7a\u9a8c\u8bc1");
        }
    }

    private boolean isEmptiable(Class<?> type) {
        return CharSequence.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray() || Map.class.isAssignableFrom(type) || Dictionary.class.isAssignableFrom(type);
    }

    private String verifyValue(String str, Object value, Constraint cst) {
        String error = this.verify(str, value, cst);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return StringUtils.isNotBlank((CharSequence)cst.msg()) ? cst.msg() + ";" : error;
        }
        return EMPTY;
    }

    private String verify(String n, Object v, Constraint c) {
        if (!c.notNull() && v == null) {
            return EMPTY;
        }
        if (c.notBlank() && StringUtils.isBlank((CharSequence)((CharSequence)v))) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u4e3a\u7a7a\u4e32;";
        }
        if (c.notEmpty() && ObjectUtils.isEmpty(v)) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u4e3aempty;";
        }
        if (c.notNull() && v == null) {
            return n + "{null}\uff1a\u4e0d\u80fd\u4e3anull;";
        }
        if (!(!c.notNull() && v == null || !StringUtils.isNotBlank((CharSequence)c.regExp()) || v != null && RegexUtils.matches(v.toString(), c.regExp()))) {
            return n + "{" + v + "}\uff1a\u683c\u5f0f\u4e0d\u5339\u914d" + c.regExp() + ";";
        }
        if (c.maxLen() > -1 && v != null && ((CharSequence)v).length() > c.maxLen()) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u5927\u4e8e" + c.maxLen() + "\u4e2a\u5b57\u7b26;";
        }
        if (c.minLen() > -1 && (v == null || ((CharSequence)v).length() < c.minLen())) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u5c0f\u4e8e" + c.minLen() + "\u4e2a\u5b57\u7b26;";
        }
        if (c.max() != Long.MAX_VALUE && v != null && Long.parseLong(v.toString()) > c.max()) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u5927\u4e8e" + c.max() + ";";
        }
        if (c.min() != Long.MIN_VALUE && (v == null || Long.parseLong(v.toString()) < c.min())) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u5c0f\u4e8e" + c.min() + ";";
        }
        long[] seqs = c.series();
        if (!(seqs == null || seqs.length <= 0 || v != null && ArrayUtils.contains((long[])seqs, (long)Long.parseLong(v.toString())))) {
            return n + "{" + v + "}\uff1a\u4e0d\u5c5e\u4e8e\u6570\u5217" + Arrays.toString(seqs) + ";";
        }
        if (c.decimalMax() != Double.POSITIVE_INFINITY && v != null && Double.parseDouble(v.toString()) > c.decimalMax()) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u5927\u4e8e" + c.decimalMax() + ";";
        }
        if (c.decimalMin() != Double.NEGATIVE_INFINITY && (v == null || Double.parseDouble(v.toString()) < c.decimalMin())) {
            return n + "{" + v + "}\uff1a\u4e0d\u80fd\u5c0f\u4e8e" + c.decimalMin() + ";";
        }
        Date date = null;
        if (StringUtils.isNotBlank((CharSequence)c.datePattern()) && (c.notNull() || v != null && !ObjectUtils.isEmpty(v))) {
            try {
                date = DateUtils.parseDateStrictly((String)((String)v), (String[])new String[]{c.datePattern()});
            }
            catch (ParseException e) {
                return n + "{" + v + "}\uff1a\u65e5\u671f\u683c\u5f0f\u4e0d\u5339\u914d" + c.datePattern() + ";";
            }
        }
        if (c.tense() != Constraint.Tense.ANY) {
            String pattern;
            if (date == null) {
                date = (Date)v;
            }
            if (StringUtils.isBlank((CharSequence)(pattern = c.datePattern()))) {
                pattern = "yyyy-MM-dd HH:mm:ss";
            }
            if (date == null) {
                return n + "{null}\uff1a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a;";
            }
            if (c.tense() == Constraint.Tense.FUTURE && date.before(new Date())) {
                return n + "{" + DateFormatUtils.format((Date)date, (String)pattern) + "}\uff1a\u4e0d\u4e3a\u5c06\u6765\u65f6\u95f4;";
            }
            if (c.tense() == Constraint.Tense.PAST && date.after(new Date())) {
                return n + "{" + DateFormatUtils.format((Date)date, (String)pattern) + "}\uff1a\u4e0d\u4e3a\u8fc7\u53bb\u65f6\u95f4;";
            }
        }
        return EMPTY;
    }
}

