/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.dag;

import cn.ponfee.commons.dag.DAGNode;
import cn.ponfee.commons.model.ToJsonString;
import com.google.common.graph.EndpointPair;
import java.io.Serializable;
import java.util.Objects;

public final class DAGEdge
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 2292231888365728538L;
    private final DAGNode source;
    private final DAGNode target;

    private DAGEdge(DAGNode source, DAGNode target) {
        this.source = Objects.requireNonNull(source, "DAG source node cannot be null.");
        this.target = Objects.requireNonNull(target, "DAG target node cannot be null.");
    }

    public static DAGEdge of(DAGNode source, DAGNode target) {
        return new DAGEdge(source, target);
    }

    public static DAGEdge of(String source, String target) {
        Objects.requireNonNull(source, "DAG source text cannot be blank.");
        Objects.requireNonNull(target, "DAG target text cannot be blank.");
        return new DAGEdge(DAGNode.fromString(source), DAGNode.fromString(target));
    }

    public static DAGEdge of(EndpointPair<DAGNode> pair) {
        Objects.requireNonNull(pair, "DAG node pair cannot be blank.");
        return new DAGEdge((DAGNode)pair.source(), (DAGNode)pair.target());
    }

    public DAGNode getSource() {
        return this.source;
    }

    public DAGNode getTarget() {
        return this.target;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DAGEdge)) {
            return false;
        }
        DAGEdge other = (DAGEdge)obj;
        return this.source.equals(other.source) && this.target.equals(other.target);
    }
}

