/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.data;

import cn.ponfee.commons.data.DataSourceFactory;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DruidDataSourceFactory
implements DataSourceFactory<DruidDataSource> {
    @Override
    public void configure(DruidDataSource ds, Properties props) {
        this.configureFilters(ds, props.getProperty("filters"));
    }

    private void configureFilters(DruidDataSource ds, String filters) {
        List list;
        boolean hasWall;
        if (StringUtils.isBlank((CharSequence)filters)) {
            return;
        }
        boolean force = (filters = filters.trim()).startsWith("!");
        if (force) {
            filters = filters.substring(1);
        }
        if (hasWall = (list = Arrays.stream(filters.split(",")).map(String::trim).collect(Collectors.toList())).remove("wall")) {
            WallConfig wallConfig = new WallConfig();
            wallConfig.setCommentAllow(true);
            wallConfig.setMultiStatementAllow(true);
            WallFilter wallFilter = new WallFilter();
            wallFilter.setConfig(wallConfig);
            ds.setProxyFilters(Collections.singletonList(wallFilter));
        }
        filters = (force ? "!" : "") + String.join((CharSequence)",", list);
        try {
            ds.setFilters(filters);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

