/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.data.lookup;

import cn.ponfee.commons.base.Initializable;
import cn.ponfee.commons.base.Releasable;
import cn.ponfee.commons.data.NamedDataSource;
import cn.ponfee.commons.data.lookup.DataSourceLookup;
import cn.ponfee.commons.data.lookup.MultipleDataSourceContext;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class MultipleFixedDataSource
extends AbstractRoutingDataSource
implements DataSourceLookup,
Initializable,
Closeable {
    private final Map<String, DataSource> dataSources;

    public MultipleFixedDataSource(NamedDataSource dataSource) {
        this(dataSource.getName(), dataSource.getDataSource(), new NamedDataSource[0]);
    }

    public MultipleFixedDataSource(NamedDataSource ... dataSources) {
        this(dataSources[0].getName(), dataSources[0].getDataSource(), (NamedDataSource[])ArrayUtils.subarray((Object[])dataSources, (int)1, (int)dataSources.length));
    }

    public MultipleFixedDataSource(String defaultName, DataSource defaultDataSource, NamedDataSource ... othersDataSource) {
        Map<String, DataSource> dataSources = MultipleDataSourceContext.process(defaultName, defaultDataSource, othersDataSource);
        super.setDefaultTargetDataSource((Object)defaultDataSource);
        super.setTargetDataSources(dataSources);
        this.dataSources = ImmutableMap.copyOf(dataSources);
    }

    protected Object determineCurrentLookupKey() {
        return MultipleDataSourceContext.get();
    }

    @Override
    public DataSource lookupDataSource(String name) {
        return this.dataSources.get(name);
    }

    @Override
    public void init() {
        this.dataSources.forEach((name, ds) -> Initializable.init(ds));
    }

    @Override
    public void close() {
        this.dataSources.forEach((name, ds) -> {
            try {
                Releasable.release(ds);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        });
    }
}

