/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.date;

import cn.ponfee.commons.date.Dates;
import cn.ponfee.commons.date.JavaUtilDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalDateTimeFormat {
    static final DateTimeFormatter PATTERN_01 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final DateTimeFormatter PATTERN_11 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    static final DateTimeFormatter PATTERN_12 = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    static final DateTimeFormatter PATTERN_13 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    static final DateTimeFormatter PATTERN_14 = DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ss");
    static final DateTimeFormatter PATTERN_21 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    static final DateTimeFormatter PATTERN_22 = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS");
    static final DateTimeFormatter PATTERN_23 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
    static final DateTimeFormatter PATTERN_24 = DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ss.SSS");
    public static final LocalDateTimeFormat DEFAULT = new LocalDateTimeFormat("yyyy-MM-dd HH:mm:ss");
    private final DateTimeFormatter backstopFormat;

    public LocalDateTimeFormat(String pattern) {
        this(DateTimeFormatter.ofPattern(pattern));
    }

    public LocalDateTimeFormat(DateTimeFormatter dateTimeFormatter) {
        this.backstopFormat = dateTimeFormatter;
    }

    public LocalDateTime parse(String source) {
        if (source == null || source.length() == 0) {
            return null;
        }
        int length = source.length();
        if (length >= 20 && JavaUtilDateFormat.isTSeparator(source) && source.endsWith("Z")) {
            if (JavaUtilDateFormat.isCrossbar(source)) {
                return LocalDateTime.ofInstant(Instant.parse(source), ZoneOffset.UTC);
            }
            source = length < 24 ? JavaUtilDateFormat.padding(source) : source.substring(0, source.length() - 1);
            return LocalDateTime.parse(source, PATTERN_24);
        }
        switch (length) {
            case 8: {
                return LocalDateTime.parse(source + "000000", PATTERN_01);
            }
            case 10: {
                char c = source.charAt(4);
                if (c == '-') {
                    return LocalDateTime.parse(source + " 00:00:00", PATTERN_11);
                }
                if (c == '/') {
                    return LocalDateTime.parse(source + " 00:00:00", PATTERN_12);
                }
                if (!JavaUtilDateFormat.DATE_TIMESTAMP_PATTERN.matcher(source).matches()) break;
                return Dates.toLocalDateTime(new Date(Long.parseLong(source) * 1000L));
            }
            case 13: {
                if (!JavaUtilDateFormat.DATE_TIMESTAMP_PATTERN.matcher(source).matches()) break;
                return Dates.toLocalDateTime(new Date(Long.parseLong(source)));
            }
            case 14: {
                return LocalDateTime.parse(source, PATTERN_01);
            }
            case 19: {
                if (JavaUtilDateFormat.isTSeparator(source)) {
                    return LocalDateTime.parse(source, JavaUtilDateFormat.isCrossbar(source) ? PATTERN_13 : PATTERN_14);
                }
                return LocalDateTime.parse(source, JavaUtilDateFormat.isCrossbar(source) ? PATTERN_11 : PATTERN_12);
            }
            case 23: {
                if (JavaUtilDateFormat.isTSeparator(source)) {
                    return LocalDateTime.parse(source, JavaUtilDateFormat.isCrossbar(source) ? PATTERN_23 : PATTERN_24);
                }
                return LocalDateTime.parse(source, JavaUtilDateFormat.isCrossbar(source) ? PATTERN_21 : PATTERN_22);
            }
        }
        return LocalDateTime.parse(source, this.backstopFormat);
    }

    public String format(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return this.backstopFormat.format(dateTime);
    }
}

