/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.exception;

import cn.ponfee.commons.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Throwables {
    private static final Logger LOG = LoggerFactory.getLogger(Throwables.class);

    public static String getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return ExceptionUtils.getStackTrace((Throwable)throwable);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        List list = ExceptionUtils.getThrowableList((Throwable)throwable);
        for (int i = list.size() - 1; i >= 0; --i) {
            String message = ((Throwable)list.get(i)).getMessage();
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            return "error: " + message;
        }
        return "error: <" + ClassUtils.getName(throwable.getClass()) + ">";
    }

    @FunctionalInterface
    public static interface ThrowingFunction<E, R, T extends Throwable> {
        public R apply(E var1) throws T;

        public static <E, R> R apply(ThrowingFunction<E, R, ?> function, E arg) {
            try {
                return function.apply(arg);
            }
            catch (Throwable t) {
                return (R)ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <E, R, T extends Throwable> Function<E, R> checked(ThrowingFunction<E, R, T> function) {
            return e -> {
                try {
                    return function.apply(e);
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <E, R> R ignored(ThrowingFunction<E, R, ?> function, E arg) {
            return ThrowingFunction.ignored(function, arg, null);
        }

        public static <E, R> R ignored(ThrowingFunction<E, R, ?> function, E arg, R defaultValue) {
            try {
                return function.apply(arg);
            }
            catch (Throwable t) {
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }

        public static <E, R> R caught(ThrowingFunction<E, R, ?> function, E arg) {
            return ThrowingFunction.caught(function, arg, null, () -> "");
        }

        public static <E, R> R caught(ThrowingFunction<E, R, ?> function, E arg, R defaultValue, Supplier<String> message) {
            try {
                return function.apply(arg);
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<E, T extends Throwable> {
        public void accept(E var1) throws T;

        public static <E> void accept(ThrowingConsumer<E, ?> consumer, E arg) {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <E, T extends Throwable> Consumer<E> checked(ThrowingConsumer<E, T> consumer) {
            return e -> {
                try {
                    consumer.accept(e);
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <E> void ignored(ThrowingConsumer<E, ?> consumer, E arg) {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                Threads.interruptIfNecessary(t);
            }
        }

        public static <E> void caught(ThrowingConsumer<E, ?> consumer, E arg) {
            ThrowingConsumer.caught(consumer, arg, null);
        }

        public static <E> void caught(ThrowingConsumer<E, ?> consumer, E arg, Supplier<String> message) {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingCallable<R, T extends Throwable> {
        public R call() throws T;

        public static <R> R call(ThrowingCallable<R, ?> callable) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                return (R)ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <R, T extends Throwable> Callable<R> checked(ThrowingCallable<R, T> callable) {
            return () -> {
                try {
                    return callable.call();
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <R> R ignored(ThrowingCallable<R, ?> callable) {
            return ThrowingCallable.ignored(callable, null);
        }

        public static <R> R ignored(ThrowingCallable<R, ?> callable, R defaultValue) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }

        public static <R> R caught(ThrowingCallable<R, ?> callable, String message) {
            return ThrowingCallable.caught(callable, null, () -> message);
        }

        public static <R> R caught(ThrowingCallable<R, ?> callable, R defaultValue, Supplier<String> message) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R, T extends Throwable> {
        public R get() throws T;

        public static <R> R get(ThrowingSupplier<R, ?> supplier) {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                return (R)ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <R, T extends Throwable> Supplier<R> checked(ThrowingSupplier<R, T> supplier) {
            return () -> {
                try {
                    return supplier.get();
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <R> R ignored(ThrowingSupplier<R, ?> supplier) {
            return ThrowingSupplier.ignored(supplier, null);
        }

        public static <R> R ignored(ThrowingSupplier<R, ?> supplier, R defaultValue) {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }

        public static <R> R caught(ThrowingSupplier<R, ?> supplier) {
            return ThrowingSupplier.caught(supplier, null, () -> "");
        }

        public static <R> R caught(ThrowingSupplier<R, ?> supplier, R defaultValue, Supplier<String> message) {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Throwable> {
        public void run() throws T;

        public static void run(ThrowingRunnable<?> runnable) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <T extends Throwable> Runnable checked(ThrowingRunnable<T> runnable) {
            return () -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static void ignored(ThrowingRunnable<?> runnable) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                Threads.interruptIfNecessary(t);
            }
        }

        public static void caught(ThrowingRunnable<?> runnable) {
            ThrowingRunnable.caught(runnable, "");
        }

        public static void caught(ThrowingRunnable<?> runnable, String message) {
            ThrowingRunnable.caught(runnable, () -> message);
        }

        public static void caught(ThrowingRunnable<?> runnable, Supplier<String> message) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
            }
        }
    }
}

