/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.export;

import cn.ponfee.commons.export.AbstractDataExporter;
import cn.ponfee.commons.export.CellStyleOptions;
import cn.ponfee.commons.export.Table;
import cn.ponfee.commons.export.Thead;
import cn.ponfee.commons.export.Tmeta;
import cn.ponfee.commons.math.Numbers;
import cn.ponfee.commons.tree.FlatNode;
import cn.ponfee.commons.util.Colors;
import cn.ponfee.commons.util.ImageUtils;
import cn.ponfee.commons.util.ObjectUtils;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExcelExporter
extends AbstractDataExporter<byte[]> {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    private static final int DEFAULT_WIDTH = 3200;
    private static final short DEFAULT_HEIGHT = 350;
    private static final double RATE_WIDTH = 70.5;
    private static final double RATE_HEIGHT = 18.0;
    private static final int MARGIN_ROW_CELL_SIZE = 26;
    private final IndexedColorMap defaultColorMap = new DefaultIndexedColorMap();
    private SXSSFWorkbook workbook;
    private final XSSFCellStyle titleStyle;
    private final XSSFCellStyle headStyle;
    private final XSSFCellStyle dataStyle;
    private final XSSFCellStyle tfootMergeStyle;
    private final XSSFCellStyle noneStyle;
    private final XSSFCellStyle tipStyle;
    private final XSSFDataFormat dataFormat;
    private final Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>();
    private final Map<String, Integer> images = new HashMap<String, Integer>();
    private final Map<String, Freeze> freezes = new HashMap<String, Freeze>();

    public ExcelExporter() {
        this.workbook = new SXSSFWorkbook(100);
        this.dataFormat = (XSSFDataFormat)this.workbook.createDataFormat();
        XSSFFont titleFont = (XSSFFont)this.workbook.createFont();
        titleFont.setBold(true);
        titleFont.setFontName("\u9ed1\u4f53");
        XSSFFont headFont = (XSSFFont)this.workbook.createFont();
        headFont.setBold(true);
        headFont.setFontName("\u5b8b\u4f53");
        XSSFFont redFont = (XSSFFont)this.workbook.createFont();
        redFont.setColor(new XSSFColor(new Color(255, 0, 0), this.defaultColorMap));
        redFont.setFontName("\u5b8b\u4f53");
        XSSFCellStyle baseStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        baseStyle.setBorderLeft(BorderStyle.THIN);
        baseStyle.setBorderTop(BorderStyle.THIN);
        baseStyle.setBorderRight(BorderStyle.THIN);
        baseStyle.setBorderBottom(BorderStyle.THIN);
        baseStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        baseStyle.setWrapText(true);
        baseStyle.setDataFormat(this.dataFormat.getFormat("@"));
        this.titleStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.titleStyle.cloneStyleFrom((CellStyle)baseStyle);
        this.titleStyle.setAlignment(HorizontalAlignment.CENTER);
        this.titleStyle.setFont((Font)titleFont);
        this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.titleStyle.setFillForegroundColor(new XSSFColor(new Color(255, 255, 224), this.defaultColorMap));
        this.headStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.headStyle.cloneStyleFrom((CellStyle)baseStyle);
        this.headStyle.setAlignment(HorizontalAlignment.CENTER);
        this.headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headStyle.setFillForegroundColor(new XSSFColor(new Color(192, 192, 192), this.defaultColorMap));
        this.headStyle.setFont((Font)headFont);
        this.headStyle.setWrapText(false);
        this.dataStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.dataStyle.cloneStyleFrom((CellStyle)baseStyle);
        this.dataStyle.setWrapText(false);
        this.tfootMergeStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.tfootMergeStyle.cloneStyleFrom((CellStyle)this.dataStyle);
        this.tfootMergeStyle.setFont((Font)headFont);
        this.tfootMergeStyle.setWrapText(false);
        this.tfootMergeStyle.setAlignment(HorizontalAlignment.RIGHT);
        this.tfootMergeStyle.setBorderLeft(BorderStyle.THIN);
        this.tfootMergeStyle.setBorderTop(BorderStyle.THIN);
        this.tfootMergeStyle.setBorderRight(BorderStyle.THIN);
        this.tfootMergeStyle.setBorderBottom(BorderStyle.THIN);
        this.tipStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.tipStyle.cloneStyleFrom((CellStyle)baseStyle);
        this.tipStyle.setFont((Font)redFont);
        this.noneStyle = (XSSFCellStyle)this.workbook.createCellStyle();
        this.noneStyle.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    @Override
    public <E> void build(Table<E> table) {
        List<FlatNode<Integer, Thead>> flats = table.getThead();
        if (CollectionUtils.isEmpty(flats)) {
            throw new IllegalArgumentException("thead can't be null");
        }
        String name = this.getName();
        SXSSFSheet sheet = this.getSheet(name);
        CursorRowNumber cursorRow = new CursorRowNumber(Math.max(sheet.getLastRowNum(), 0));
        if (cursorRow.get() > 0) {
            cursorRow.increment();
            int i2 = cursorRow.getAndIncrement();
            int j = cursorRow.getAndIncrement();
            SXSSFRow row1 = sheet.createRow(i2);
            row1.setHeight((short)350);
            SXSSFRow row2 = sheet.createRow(j);
            row2.setHeight((short)350);
            for (int k = 0; k < 26; ++k) {
                this.createCell(row1, k, this.noneStyle, null);
                this.createCell(row2, k, this.noneStyle, null);
            }
            sheet.addMergedRegion(new CellRangeAddress(i2, j, 0, 25));
        }
        this.buildComplexThead(table, sheet, cursorRow);
        Freeze freeze = this.freezes.get(name);
        if (freeze != null) {
            freeze.disable();
        } else {
            this.freezes.put(name, new Freeze(1, cursorRow.get()));
        }
        Map<CellStyleOptions, Object> options = table.getOptions();
        List<Thead> leafs = this.getLeafThead(flats);
        List<XSSFCellStyle> styles = this.createStyles(leafs);
        this.rollingTbody(table, (data, i) -> {
            SXSSFRow row = sheet.createRow(cursorRow.getAndIncrement());
            int m = ((Object[])data).length;
            for (int j = 0; j < m; ++j) {
                this.createCell(row, j, (XSSFCellStyle)styles.get(j), this.getTmeta(leafs, j), data[j], (int)i, j, options);
            }
        });
        int totalLeafCount = flats.get(0).getTreeLeafCount();
        if (table.isEmptyTbody()) {
            this.createBlankRow("No results found", sheet, this.tipStyle, cursorRow, totalLeafCount);
        } else {
            super.nonEmpty();
        }
        Object[] tfoots = table.getTfoot();
        if (ArrayUtils.isNotEmpty((Object[])tfoots)) {
            int i3;
            int rowNum = cursorRow.getAndIncrement();
            SXSSFRow row = sheet.createRow(rowNum);
            row.setHeight((short)350);
            if (table.getTfoot().length > totalLeafCount) {
                throw new IllegalStateException("tfoot data length cannot more than total leaf count.");
            }
            int mergeNum = totalLeafCount - table.getTfoot().length;
            for (i3 = 0; i3 < mergeNum; ++i3) {
                this.createCell(row, i3, this.tfootMergeStyle, i3 == 0 ? "\u5408\u8ba1" : null);
            }
            if (mergeNum > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowNum, rowNum, 0, mergeNum - 1));
            }
            for (i3 = 0; i3 < tfoots.length; ++i3) {
                this.createCell(row, i3 + mergeNum, styles.get(mergeNum + i3), this.getTmeta(leafs, mergeNum + i3), tfoots[i3]);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)table.getComment())) {
            this.createBlankRow(table.getComment(), sheet, this.tipStyle, cursorRow, totalLeafCount);
        }
    }

    public void insertImage(byte[] imageBytes) {
        int[] size = ImageUtils.getImageSize(new ByteArrayInputStream(imageBytes));
        this.insertImage(imageBytes, size[0], size[1]);
    }

    public void insertImage(byte[] imageBytes, int width, int height) {
        if (imageBytes == null || imageBytes.length == 0) {
            return;
        }
        super.nonEmpty();
        SXSSFSheet sheet = this.getSheet(this.getName());
        int startRow = Optional.ofNullable(this.images.get(this.getName())).orElse(1);
        int startCol = 1;
        int endCol = startCol + (int)Math.round((double)width / 70.5);
        int endRow = startRow + (int)Math.round((double)height / 18.0);
        this.images.put(this.getName(), endRow + 2);
        SXSSFDrawing drawing = sheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, width, height, startCol, startRow, (int)((short)endCol), endRow);
        anchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
        drawing.createPicture((ClientAnchor)anchor, this.workbook.addPicture(imageBytes, 6));
    }

    public void write(OutputStream out) {
        try (BufferedOutputStream bos = new BufferedOutputStream(out);
             SXSSFWorkbook wb = this.workbook;){
            this.createFreezePane();
            wb.write((OutputStream)bos);
            wb.dispose();
            this.workbook = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(String filepath) {
        this.write(new File(filepath));
    }

    public void write(File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] export() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        this.write(out);
        return out.toByteArray();
    }

    @Override
    public void close() {
        if (this.workbook == null) {
            return;
        }
        try (SXSSFWorkbook wb = this.workbook;){
            wb.dispose();
            this.workbook = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.sheets.clear();
            this.images.clear();
            this.freezes.clear();
        }
    }

    protected SXSSFSheet getSheet(String name) {
        SXSSFSheet sheet = this.sheets.get(name);
        if (sheet == null) {
            sheet = this.workbook.createSheet(name);
            sheet.setDisplayGridlines(false);
            this.sheets.put(name, sheet);
        }
        return sheet;
    }

    protected void removeSheet(String name) {
        this.workbook.removeSheetAt(this.workbook.getSheetIndex((Sheet)this.sheets.get(name)));
        this.sheets.remove(name);
    }

    private void createFreezePane() {
        for (Map.Entry<String, SXSSFSheet> entry : this.sheets.entrySet()) {
            Freeze freeze = this.freezes.get(entry.getKey());
            if (freeze == null || !freeze.freeze) continue;
            entry.getValue().createFreezePane(freeze.colSplit, freeze.rowSplit);
        }
    }

    private <E> void buildComplexThead(Table<E> table, SXSSFSheet sheet, CursorRowNumber cursorRow) {
        List<FlatNode<Integer, Thead>> flats = table.getThead();
        FlatNode<Integer, Thead> root = flats.get(0);
        int totalLeafCount = root.getTreeLeafCount();
        List<FlatNode<Integer, Thead>> thead = flats.subList(1, flats.size());
        if (StringUtils.isNotBlank((CharSequence)table.getCaption())) {
            this.createBlankRow(table.getCaption(), sheet, this.titleStyle, cursorRow, totalLeafCount);
        }
        HashSet<Integer> rows = new HashSet<Integer>();
        int lastLevel = 1;
        int treeDepth = root.getTreeDepth() - 1;
        int n = thead.size();
        for (int i = 0; i < n; ++i) {
            SXSSFRow colRow;
            int endRow;
            FlatNode<Integer, Thead> flat = thead.get(i);
            int cellLevel = flat.getLevel() - 1;
            if (cellLevel > lastLevel) {
                lastLevel = cellLevel;
                cursorRow.increment();
            }
            int beginCol = flat.getLeftLeafCount();
            int endCol = beginCol + flat.getTreeLeafCount() - 1;
            if (flat.isLeaf()) {
                endRow = cursorRow.get() + treeDepth - cellLevel;
                sheet.setColumnWidth(beginCol, 3200);
            } else {
                endRow = cursorRow.get();
            }
            if (rows.add(cursorRow.get())) {
                colRow = sheet.createRow(cursorRow.get());
                colRow.setHeight((short)350);
            } else {
                colRow = sheet.getRow(cursorRow.get());
            }
            this.createCell(colRow, beginCol, this.headStyle, ((Thead)flat.getAttach()).getName());
            for (int b = beginCol + 1; b <= endCol; ++b) {
                this.createCell(colRow, b, this.headStyle, null);
            }
            for (int a = cursorRow.get() + 1; a <= endRow; ++a) {
                if (rows.add(a)) {
                    colRow = sheet.createRow(a);
                    colRow.setHeight((short)350);
                } else {
                    colRow = sheet.getRow(a);
                }
                for (int b = beginCol; b <= endCol; ++b) {
                    this.createCell(colRow, b, this.headStyle, null);
                }
            }
            if (cursorRow.get() == endRow && beginCol == endCol) continue;
            sheet.addMergedRegion(new CellRangeAddress(cursorRow.get(), endRow, beginCol, endCol));
        }
        cursorRow.increment();
    }

    private Tmeta getTmeta(List<Thead> thead, int index) {
        return thead.get(index).getTmeta();
    }

    private void createBlankRow(String text, SXSSFSheet sheet, XSSFCellStyle style, CursorRowNumber cursorRow, int columnLen) {
        SXSSFRow row = sheet.createRow(cursorRow.get());
        row.setHeight((short)350);
        this.createCell(row, 0, style, text);
        for (int i = 1; i < columnLen; ++i) {
            this.createCell(row, i, style, null);
        }
        sheet.addMergedRegion(new CellRangeAddress(cursorRow.get(), cursorRow.get(), 0, columnLen - 1));
        cursorRow.increment();
    }

    private void createCell(SXSSFRow row, int colIndex, XSSFCellStyle style, Tmeta tmeta, Object value) {
        this.createCell(row, colIndex, style, tmeta, value, -1, -1, null);
    }

    private void createCell(SXSSFRow row, int colIndex, XSSFCellStyle style, Object value) {
        this.createCell(row, colIndex, style, null, value, -1, -1, null);
    }

    private void createCell(SXSSFRow row, int colIndex, XSSFCellStyle style, Tmeta tmeta, Object value, int tbodyRowIdx, int tbodyColIdx, Map<CellStyleOptions, Object> options) {
        SXSSFCell cell = row.createCell(colIndex);
        cell.setCellStyle((CellStyle)style);
        if (tmeta == null) {
            ExcelExporter.setCellString(cell, value);
        } else if (tmeta.getType() == Tmeta.Type.NUMERIC) {
            if (ObjectUtils.isEmpty(value)) {
                cell.setCellType(CellType.NUMERIC);
                cell.setCellValue((RichTextString)new XSSFRichTextString());
            } else if (value instanceof String && ((String)value).endsWith("%")) {
                String val = ((String)value).substring(0, ((String)value).length() - 1);
                cell.setCellValue(Numbers.toDouble(val.replace(",", "")) / 100.0);
            } else {
                cell.setCellValue(Numbers.toDouble(value.toString().replace(",", "")));
            }
        } else if (tmeta.getType() == Tmeta.Type.DATETIME) {
            if (value == null) {
                cell.setCellType(CellType.BLANK);
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            } else if (value instanceof Calendar) {
                cell.setCellValue((Calendar)value);
            } else {
                String str = value.toString();
                String format = Optional.ofNullable(tmeta.getFormat()).orElse("yyyy-MM-dd HH:mm:ss");
                try {
                    cell.setCellValue(DateUtils.parseDateStrictly((String)str, (String[])new String[]{format}));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("invalid date str: " + str + ", format: " + format, e);
                }
            }
        } else {
            ExcelExporter.setCellString(cell, value);
        }
        this.processOptions(cell, tbodyRowIdx, tbodyColIdx, options);
    }

    private void processOptions(SXSSFCell cell, int tbodyRowIdx, int tbodyColIdx, Map<CellStyleOptions, Object> options) {
        Consumer processor;
        if (MapUtils.isEmpty(options)) {
            return;
        }
        Map highlight = (Map)options.get((Object)CellStyleOptions.HIGHLIGHT);
        if (MapUtils.isNotEmpty((Map)highlight)) {
            for (List c : (List)highlight.get("cells")) {
                if ((Integer)c.get(0) != tbodyRowIdx || (Integer)c.get(1) != tbodyColIdx) continue;
                XSSFFont font = (XSSFFont)this.workbook.createFont();
                font.setColor(new XSSFColor(Colors.fromHex((String)highlight.get("color")), this.defaultColorMap));
                XSSFCellStyle style = (XSSFCellStyle)this.workbook.createCellStyle();
                style.cloneStyleFrom(cell.getCellStyle());
                style.setFont((Font)font);
                cell.setCellStyle((CellStyle)style);
            }
        }
        if ((processor = (Consumer)options.get((Object)CellStyleOptions.CELL_PROCESS)) != null) {
            processor.accept(new Object[]{this.workbook, cell, tbodyRowIdx, tbodyColIdx});
        }
    }

    private List<XSSFCellStyle> createStyles(List<Thead> thead) {
        ArrayList<XSSFCellStyle> styles = new ArrayList<XSSFCellStyle>(thead.size());
        for (Thead flat : thead) {
            XSSFCellStyle style = (XSSFCellStyle)this.workbook.createCellStyle();
            styles.add(style);
            style.cloneStyleFrom((CellStyle)this.dataStyle);
            Tmeta tmeta = flat.getTmeta();
            if (tmeta == null) continue;
            switch (tmeta.getAlign()) {
                case LEFT: {
                    style.setAlignment(HorizontalAlignment.LEFT);
                    break;
                }
                case CENTER: {
                    style.setAlignment(HorizontalAlignment.CENTER);
                    break;
                }
                case RIGHT: {
                    style.setAlignment(HorizontalAlignment.RIGHT);
                    break;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)tmeta.getFormat())) {
                style.setDataFormat(this.dataFormat.getFormat(tmeta.getFormat()));
            }
            if (tmeta.getColor() == null) continue;
            XSSFFont font = (XSSFFont)this.workbook.createFont();
            font.setColor(new XSSFColor(tmeta.getColor(), this.defaultColorMap));
            style.setFont((Font)font);
        }
        return styles;
    }

    private static void setCellString(SXSSFCell cell, Object value) {
        if (value != null) {
            cell.setCellValue(value.toString());
        } else {
            cell.setCellType(CellType.BLANK);
        }
    }

    private static final class Freeze {
        boolean freeze = true;
        final int colSplit;
        final int rowSplit;

        Freeze(int colSplit, int rowSplit) {
            this.colSplit = colSplit;
            this.rowSplit = rowSplit;
        }

        void enable() {
            this.freeze = true;
        }

        void disable() {
            this.freeze = false;
        }
    }

    private static final class CursorRowNumber {
        int current;

        CursorRowNumber() {
            this(0);
        }

        CursorRowNumber(int initValue) {
            this.current = initValue;
        }

        int getAndIncrement() {
            return this.current++;
        }

        int incrementAndGet() {
            return ++this.current;
        }

        int getAndDecrement() {
            return this.current--;
        }

        int decrementAndGet() {
            return --this.current;
        }

        void add(int i) {
            this.current += i;
        }

        int addAndGet(int i) {
            this.current += i;
            return this.current;
        }

        int getAndAdd(int i) {
            int temp = this.current;
            this.current += i;
            return temp;
        }

        void set(int i) {
            this.current = i;
        }

        int getAndSet(int i) {
            int temp = this.current;
            this.current = i;
            return temp;
        }

        int get() {
            return this.current;
        }

        void increment() {
            ++this.current;
        }
    }
}

