/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.extract;

import cn.ponfee.commons.date.Dates;
import cn.ponfee.commons.extract.DataExtractor;
import cn.ponfee.commons.extract.ExtractableDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelExtractor
extends DataExtractor {
    protected final ExcelType type;
    protected final int sheetIndex;
    private final int startRow;

    protected ExcelExtractor(ExtractableDataSource dataSource, String[] headers, int startRow, ExcelType type, int sheetIndex) {
        super(dataSource, headers);
        this.startRow = startRow;
        this.type = type;
        this.sheetIndex = sheetIndex;
    }

    @Override
    public final void extract(BiConsumer<Integer, String[]> processor) throws IOException {
        try (ExtractableDataSource ds = this.dataSource;
             Workbook workbook = this.createWorkbook(ds);){
            this.extract(workbook, processor);
        }
    }

    protected Workbook createWorkbook(ExtractableDataSource dataSource) throws IOException {
        Object ds = dataSource.getDataSource();
        if (ds instanceof File) {
            return WorkbookFactory.create((File)((File)ds));
        }
        return WorkbookFactory.create((InputStream)((InputStream)ds));
    }

    private void extract(Workbook workbook, BiConsumer<Integer, String[]> processor) {
        int columnSize;
        boolean specHeaders;
        if (ArrayUtils.isNotEmpty((Object[])this.headers)) {
            specHeaders = true;
            columnSize = this.headers.length;
        } else {
            specHeaders = false;
            columnSize = 0;
        }
        Iterator iter = workbook.getSheetAt(this.sheetIndex).iterator();
        int i = 0;
        int k = 0;
        while (iter.hasNext() && !this.end) {
            Row row = (Row)iter.next();
            if (row != null && i >= this.startRow) {
                int j;
                if (!specHeaders && i == this.startRow) {
                    columnSize = row.getLastCellNum();
                }
                String[] data = new String[columnSize];
                int m = row.getLastCellNum();
                for (j = 0; j <= m && j < columnSize; ++j) {
                    data[j] = ExcelExtractor.getStringCellValue(row.getCell(j, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK));
                }
                while (j < columnSize) {
                    data[j] = null;
                    ++j;
                }
                if (this.isNotEmpty(data)) {
                    processor.accept(k++, data);
                }
            }
            ++i;
        }
    }

    private static String getStringCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                return ExcelExtractor.getNumericAsString(cell);
            }
            case FORMULA: {
                try {
                    return ExcelExtractor.getNumericAsString(cell);
                }
                catch (Exception e) {
                    return cell.getRichStringCellValue().getString();
                }
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case ERROR: {
                return "Error: " + cell.getErrorCellValue();
            }
        }
        return cell.getRichStringCellValue().getString();
    }

    private static String getNumericAsString(Cell cell) {
        return DateUtil.isCellDateFormatted((Cell)cell) || DateUtil.isCellInternalDateFormatted((Cell)cell) ? Dates.format(cell.getDateCellValue()) : String.valueOf(cell.getNumericCellValue());
    }

    public static enum ExcelType {
        XLS,
        XLSX;

    }
}

