/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.extract.streaming;

import cn.ponfee.commons.extract.ExcelExtractor;
import cn.ponfee.commons.extract.ExtractableDataSource;
import cn.ponfee.commons.extract.streaming.xls.HSSFStreamingReader;
import com.monitorjbl.xlsx.StreamingReader;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.Executor;
import org.apache.poi.ss.usermodel.Workbook;

public class StreamingExcelExtractor
extends ExcelExtractor {
    private final Executor executor;

    public StreamingExcelExtractor(ExtractableDataSource dataSource, String[] headers, int startRow, ExcelExtractor.ExcelType type) {
        this(dataSource, headers, startRow, type, 0, null);
    }

    public StreamingExcelExtractor(ExtractableDataSource dataSource, String[] headers, int startRow, ExcelExtractor.ExcelType type, int sheetIndex) {
        this(dataSource, headers, startRow, type, sheetIndex, null);
    }

    public StreamingExcelExtractor(ExtractableDataSource dataSource, String[] headers, int startRow, ExcelExtractor.ExcelType type, int sheetIndex, Executor executor) {
        super(dataSource, headers, startRow, type, sheetIndex);
        this.executor = executor;
    }

    @Override
    protected Workbook createWorkbook(ExtractableDataSource dataSource) {
        Object ds = dataSource.getDataSource();
        switch (this.type) {
            case XLS: {
                HSSFStreamingReader reader = HSSFStreamingReader.create(200, this.sheetIndex);
                return ds instanceof File ? reader.open((File)ds, this.executor) : reader.open((InputStream)ds, this.executor);
            }
            case XLSX: {
                StreamingReader.Builder builder = StreamingReader.builder().rowCacheSize(50).bufferSize(4096);
                return ds instanceof File ? builder.open((File)ds) : builder.open((InputStream)ds);
            }
        }
        throw new RuntimeException("Unknown excel type: " + (Object)((Object)this.type));
    }
}

