/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.extract.streaming.xls;

import cn.ponfee.commons.extract.streaming.xls.HSSFStreamingCell;
import cn.ponfee.commons.extract.streaming.xls.HSSFStreamingRow;
import cn.ponfee.commons.extract.streaming.xls.HSSFStreamingSheet;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellReferenceType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;

public class HSSFStreamingWorkbook
implements Workbook,
Closeable {
    public static final int AWAIT_MILLIS = 47;
    private volatile boolean allSheetReadied = false;
    private final List<Sheet> sheets = new ArrayList<Sheet>();

    public HSSFStreamingWorkbook(InputStream input, int rowCacheSize, int[] sheetIndexs, String[] sheetNames, Executor executor) {
        executor.execute(new AsyncHSSFReader(rowCacheSize, sheetIndexs, sheetNames, input));
    }

    public Iterator<Sheet> iterator() {
        this.awaitReadAllSheet();
        return this.sheets.iterator();
    }

    public Iterator<Sheet> sheetIterator() {
        this.awaitReadAllSheet();
        return this.iterator();
    }

    public String getSheetName(int sheet) {
        this.awaitReadAllSheet();
        return this.sheets.get(sheet).getSheetName();
    }

    public int getSheetIndex(String name) {
        this.awaitReadAllSheet();
        for (int i = 0; i < this.sheets.size(); ++i) {
            if (!this.sheets.get(i).getSheetName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getSheetIndex(Sheet sheet) {
        this.awaitReadAllSheet();
        for (int i = 0; i < this.sheets.size(); ++i) {
            if (this.sheets.get(i) != sheet) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfSheets() {
        this.awaitReadAllSheet();
        return this.sheets.size();
    }

    public Sheet getSheetAt(int index) {
        this.awaitReadAllSheet();
        return this.sheets.size() > index ? this.sheets.get(index) : null;
    }

    public Sheet getSheet(String name) {
        this.awaitReadAllSheet();
        for (Sheet sheet : this.sheets) {
            if (!sheet.getSheetName().equals(name)) continue;
            return sheet;
        }
        return null;
    }

    @Override
    public void close() {
    }

    private void awaitReadAllSheet() {
        try {
            while (!this.allSheetReadied) {
                Thread.sleep(47L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public boolean isSheetHidden(int sheetIx) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isSheetVeryHidden(int sheetIx) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getActiveSheetIndex() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setActiveSheet(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getFirstVisibleTab() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setFirstVisibleTab(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setSheetOrder(String sheetname, int pos) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setSelectedTab(int index) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setSheetName(int sheet, String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Sheet createSheet() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Sheet createSheet(String sheetname) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Sheet cloneSheet(int sheetNum) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeSheetAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Font createFont() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Font findFont(boolean bold, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getNumberOfFonts() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getNumberOfFontsAsInt() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Font getFontAt(int idx) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CellStyle createCellStyle() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getNumCellStyles() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CellStyle getCellStyleAt(int idx) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void write(OutputStream stream) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getNumberOfNames() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Name getName(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public List<? extends Name> getNames(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public List<? extends Name> getAllNames() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Name createName() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeName(Name name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int linkExternalWorkbook(String name, Workbook workbook) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setPrintArea(int sheetIndex, String reference) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getPrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removePrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Row.MissingCellPolicy getMissingCellPolicy() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DataFormat createDataFormat() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int addPicture(byte[] pictureData, int format) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public List<? extends PictureData> getAllPictures() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CreationHelper getCreationHelper() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setHidden(boolean hiddenFlag) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setSheetHidden(int sheetIx, boolean hidden) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public SheetVisibility getSheetVisibility(int sheetIx) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setSheetVisibility(int sheetIx, SheetVisibility visibility) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addToolPack(UDFFinder toopack) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setForceFormulaRecalculation(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public SpreadsheetVersion getSpreadsheetVersion() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int addOlePackage(byte[] oleData, String label, String fileName, String command) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public EvaluationWorkbook createEvaluationWorkbook() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CellReferenceType getCellReferenceType() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setCellReferenceType(CellReferenceType cellReferenceType) {
        throw new UnsupportedOperationException();
    }

    private class AsyncHSSFReader
    implements HSSFListener,
    Runnable {
        private final InputStream input;
        private final int rowCacheSize;
        private final int[] sheetIndexs;
        private final String[] sheetNames;
        private int currentSheetIndex = -1;
        private HSSFStreamingSheet currentSheet;
        private int currentRowNumber = -1;
        private int currentRowOrder = -1;
        private HSSFStreamingRow currentRow;
        private SSTRecord sstrec;
        private FormatTrackingHSSFListener formatListener;

        private AsyncHSSFReader(int rowCacheSize, int[] sheetIndexs, String[] sheetNames, InputStream input) {
            this.rowCacheSize = rowCacheSize;
            this.sheetIndexs = sheetIndexs;
            this.sheetNames = sheetNames;
            this.input = input;
        }

        @Override
        public void run() {
            try (InputStream steam = this.input;
                 POIFSFileSystem poi = new POIFSFileSystem(steam);
                 DocumentInputStream doc = poi.createDocumentInputStream("Workbook");){
                HSSFRequest request = new HSSFRequest();
                this.formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)this));
                request.addListenerForAllRecords((HSSFListener)this.formatListener);
                new HSSFEventFactory().processEvents(request, (InputStream)doc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.endRead();
            }
        }

        public void processRecord(Record record) {
            if (record instanceof BOFRecord) {
                if (((BOFRecord)record).getType() == 16) {
                    HSSFStreamingWorkbook.this.allSheetReadied = true;
                    if (this.currentSheet != null) {
                        this.putRow(this.currentRow);
                        this.currentSheet.toEnd();
                    }
                    this.currentRow = null;
                    this.currentRowNumber = -1;
                    this.currentRowOrder = -1;
                    this.currentSheet = (HSSFStreamingSheet)HSSFStreamingWorkbook.this.sheets.get(++this.currentSheetIndex);
                }
            } else if (record instanceof BoundSheetRecord) {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                int sstIdx = HSSFStreamingWorkbook.this.sheets.size();
                HSSFStreamingWorkbook.this.sheets.add(new HSSFStreamingSheet(sstIdx, bsr.getSheetname(), this.isDiscard(sstIdx, bsr.getSheetname()), this.rowCacheSize));
            } else if (record instanceof SSTRecord) {
                this.sstrec = (SSTRecord)record;
            } else if (record instanceof CellRecord) {
                CellRecord cell = (CellRecord)record;
                if (this.currentRowNumber != cell.getRow()) {
                    this.putRow(this.currentRow);
                    this.currentRowNumber = cell.getRow();
                    this.currentRow = new HSSFStreamingRow(this.currentRowNumber, ++this.currentRowOrder);
                }
                this.currentRow.putCell(cell.getColumn(), new HSSFStreamingCell(this.getString(cell)));
            }
        }

        private void endRead() {
            HSSFStreamingWorkbook.this.allSheetReadied = true;
            if (this.currentSheet != null) {
                this.putRow(this.currentRow);
            }
            HSSFStreamingWorkbook.this.sheets.forEach(s -> ((HSSFStreamingSheet)s).toEnd());
        }

        private void putRow(HSSFStreamingRow row) {
            if (this.currentSheet.isDiscard() || row == null || row.isEmpty()) {
                return;
            }
            try {
                this.currentSheet.putRow(row);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        private boolean isDiscard(int sstIdx, String sstName) {
            if (ArrayUtils.isEmpty((int[])this.sheetIndexs) && ArrayUtils.isEmpty((Object[])this.sheetNames)) {
                return false;
            }
            return !ArrayUtils.contains((int[])this.sheetIndexs, (int)sstIdx) && !ArrayUtils.contains((Object[])this.sheetNames, (Object)sstName);
        }

        private String getString(CellRecord record) {
            switch (record.getSid()) {
                case 517: {
                    return Boolean.toString(((BoolErrRecord)record).getBooleanValue());
                }
                case 6: {
                    FormulaRecord frec = (FormulaRecord)record;
                    if (Double.isNaN(frec.getValue())) {
                        return null;
                    }
                    return this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                }
                case 253: {
                    return this.sstrec == null ? null : this.sstrec.getString(((LabelSSTRecord)record).getSSTIndex()).getString();
                }
                case 515: {
                    NumberRecord number = (NumberRecord)record;
                    if (StringUtils.containsAny((CharSequence)this.formatListener.getFormatString((CellValueRecordInterface)number), (char[])new char[]{'/', ':'})) {
                        return this.formatListener.formatNumberDateCell((CellValueRecordInterface)number);
                    }
                    return String.valueOf(number.getValue());
                }
            }
            return null;
        }
    }
}

