/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.io;

import cn.ponfee.commons.io.charset.TikaDetector;
import cn.ponfee.commons.math.Numbers;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CharsetDetector {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final int DEFAULT_DETECT_LENGTH = 3600;

    public static Charset detect(String path) {
        return CharsetDetector.detect(path, 3600);
    }

    public static Charset detect(String path, int length) {
        return CharsetDetector.detect(new File(path), length);
    }

    public static Charset detect(File file) {
        return CharsetDetector.detect(file, 3600);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(File file, int length) {
        try (FileInputStream input = new FileInputStream(file);){
            Charset charset = CharsetDetector.detect(input, (int)Math.min(file.length(), (long)length));
            return charset;
        }
        catch (IOException e) {
            throw new RuntimeException("Detect file '" + file.getPath() + "' occur error.", e);
        }
    }

    public static Charset detect(URL url) {
        return CharsetDetector.detect(url, 3600);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(URL url, int length) {
        try (InputStream input = url.openStream();){
            Charset charset = CharsetDetector.detect(input, length);
            return charset;
        }
        catch (IOException e) {
            throw new RuntimeException("Detect url '" + url.getPath() + "' occur error.", e);
        }
    }

    public static Charset detect(byte[] bytes) {
        return CharsetDetector.detect(bytes, 0, bytes.length);
    }

    public static Charset detect(byte[] bytes, int length) {
        return CharsetDetector.detect(bytes, 0, length);
    }

    public static Charset detect(byte[] bytes, int offset, int length) {
        offset = Numbers.bounds(offset, 0, bytes.length);
        length = Numbers.bounds(length, 0, bytes.length - offset);
        try {
            return CharsetDetector.detect(new ByteArrayInputStream(bytes, offset, length), length);
        }
        catch (IOException e) {
            throw new RuntimeException("Detect byte array charset occur error.", e);
        }
    }

    public static Charset detect(InputStream input) throws IOException {
        return CharsetDetector.detect(input, 3600);
    }

    public static Charset detect(InputStream input, int length) throws IOException {
        return TikaDetector.detect(input, length);
    }
}

