/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.io;

import cn.ponfee.commons.io.CharsetDetector;
import cn.ponfee.commons.io.Files;
import cn.ponfee.commons.io.WrappedBufferedReader;
import cn.ponfee.commons.io.WrappedBufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FileTransformer {
    private static final int FIX_LENGTH = 85;
    private static final String[] CHARSETS = new String[]{"GBK", "GB2312", "UTF-8", "UTF-16", "UTF-16LE", "UTF-16BE", "UTF-32", "UTF-32LE", "UTF-32BE"};
    private String includeFileExtensions = FileTransformer.regexExtensions("java", "txt", "properties", "xml", "sql", "html", "htm", "jsp", "css", "js", "log", "bak", "ini", "csv", "yml", "yaml");
    private final String sourcePath;
    private final String targetPath;
    private final String encoding;
    private final StringBuilder log = new StringBuilder(4096);
    private String[] searchList;
    private String[] replacementList;

    public FileTransformer(String source, String target) {
        this(source, target, null);
    }

    public FileTransformer(String source, String target, String encoding) {
        this.sourcePath = new File(source).getAbsolutePath();
        this.targetPath = Files.mkdir(target).getAbsolutePath();
        this.encoding = encoding;
    }

    public void setIncludeFileExtensions(String ... includeFileExtensions) {
        this.includeFileExtensions = FileTransformer.regexExtensions(includeFileExtensions);
    }

    public void setReplaceEach(String[] searchList, String[] replacementList) {
        this.searchList = searchList;
        this.replacementList = replacementList;
    }

    public void transform() {
        this.transform(new File(this.sourcePath));
    }

    public String getTransformLog() {
        return this.log.toString();
    }

    private void transform(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] subfiles = file.listFiles();
                if (subfiles != null) {
                    for (File sub : subfiles) {
                        this.transform(sub);
                    }
                }
            } else {
                String charset;
                String path = file.getAbsolutePath();
                File dest = new File(this.targetPath + path.substring(this.sourcePath.length()));
                boolean isMatch = file.getName().matches(this.includeFileExtensions);
                if (isMatch && StringUtils.isNotEmpty((CharSequence)this.encoding) && ArrayUtils.contains((Object[])CHARSETS, (Object)(charset = CharsetDetector.detect(path).name().toUpperCase())) && !this.encoding.equalsIgnoreCase(charset)) {
                    this.log.append("\u8f6c\u6362\uff1a[").append(charset).append("]").append(StringUtils.rightPad((String)path, (int)85)).append("  -->  ");
                    FileTransformer.transform(file, dest, charset, this.encoding, this.searchList, this.replacementList);
                    this.log.append("[").append(this.encoding).append("]").append(dest.getAbsolutePath()).append("\n");
                } else if (isMatch && ArrayUtils.isNotEmpty((Object[])this.searchList)) {
                    this.log.append("\u66ff\u6362\uff1a").append(StringUtils.rightPad((String)path, (int)85)).append("  -->  ");
                    FileTransformer.transform(file, dest, this.searchList, this.replacementList);
                    this.log.append(dest.getAbsolutePath()).append("\n");
                } else {
                    this.log.append("\u590d\u5236\uff1a").append(StringUtils.rightPad((String)path, (int)85)).append("  -->  ");
                    FileTransformer.transform(file, dest);
                    this.log.append(dest.getAbsolutePath()).append("\n");
                }
            }
        }
    }

    public static void transform(File source, File target) {
        try {
            target.getParentFile().mkdirs();
            java.nio.file.Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void transform(File source, File target, String[] searchList, String[] replacementList) {
        Files.touch(target);
        try (WrappedBufferedReader reader = new WrappedBufferedReader(source);
             WrappedBufferedWriter writer = new WrappedBufferedWriter(target);){
            FileTransformer.writeln(reader, writer, searchList, replacementList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void transform(File source, File target, String fromCharset, String toCharset) {
        FileTransformer.transform(source, target, fromCharset, toCharset, null, null);
    }

    public static void transform(File source, File target, String fromCharset, String toCharset, String[] searchList, String[] replacementList) {
        Files.touch(target);
        try (WrappedBufferedReader reader = new WrappedBufferedReader(source, fromCharset);
             WrappedBufferedWriter writer = new WrappedBufferedWriter(target, toCharset);){
            FileTransformer.writeln(reader, writer, searchList, replacementList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeln(WrappedBufferedReader reader, WrappedBufferedWriter writer, String[] searchList, String[] replacementList) throws IOException {
        if (searchList != null && searchList.length > 0) {
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(StringUtils.replaceEach((String)line, (String[])searchList, (String[])replacementList));
                writer.write("\n");
            }
        } else {
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
        }
    }

    private static String regexExtensions(String ... fileExtensions) {
        return "(?i)^(.+\\.)(" + String.join((CharSequence)"|", fileExtensions) + ")$";
    }
}

