/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.io;

import cn.ponfee.commons.io.ExtendedGZIPOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public final class GzipProcessor {
    static final int BYTE_SIZE = 512;

    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        GzipProcessor.compress(data, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void compress(byte[] data, OutputStream output) {
        try (ExtendedGZIPOutputStream gzout = new ExtendedGZIPOutputStream(output);){
            gzout.write(data);
            gzout.flush();
            gzout.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long compress(InputStream input, OutputStream output) {
        try (ExtendedGZIPOutputStream gzout = new ExtendedGZIPOutputStream(output);){
            long size = IOUtils.copyLarge((InputStream)input, (OutputStream)gzout);
            gzout.flush();
            gzout.finish();
            long l = size;
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decompress(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        GzipProcessor.decompress(new ByteArrayInputStream(data), (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void decompress(byte[] data, OutputStream output) {
        GzipProcessor.decompress(new ByteArrayInputStream(data), output);
    }

    public static void decompress(InputStream input, OutputStream output) {
        try (GZIPInputStream gzin = new GZIPInputStream(input);){
            IOUtils.copyLarge((InputStream)gzin, (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

