/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.io;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Pattern;

public enum HumanReadables {
    SI(1000, "B", "KB", "MB", "GB", "TB", "PB", "EB"),
    BINARY(1024, "B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB");

    private static final String FORMAT = "#,##0.##";
    private static final Pattern PATTERN;
    private final int base;
    private final String[] units;
    private final long[] sizes;

    private HumanReadables(int base, String ... units) {
        this.base = base;
        this.units = units;
        this.sizes = new long[this.units.length];
        this.sizes[0] = 1L;
        for (int i = 1; i < this.sizes.length; ++i) {
            this.sizes[i] = this.sizes[i - 1] * (long)base;
        }
    }

    public strictfp String human(long size) {
        if (size == 0L) {
            return "0 " + this.units[0];
        }
        String sign = "";
        if (size < 0L) {
            sign = "-";
            size = size == Long.MIN_VALUE ? Long.MAX_VALUE : -size;
        }
        int unit = this.find(size);
        return new StringBuilder(13).append(sign).append(new DecimalFormat(FORMAT).format((double)size / (double)this.sizes[unit])).append(" ").append(this.units[unit]).toString();
    }

    public long parse(String size) {
        return this.parse(size, false);
    }

    public strictfp long parse(String size, boolean strict) {
        if (size == null || size.isEmpty()) {
            return 0L;
        }
        if (!PATTERN.matcher(size).matches()) {
            throw new IllegalArgumentException("Invalid format [" + size + "]");
        }
        String value = size = size.trim();
        long factor = this.sizes[0];
        int sign = 1;
        switch (value.charAt(0)) {
            case '+': {
                value = value.substring(1);
                break;
            }
            case '-': {
                value = value.substring(1);
                sign = -1;
                break;
            }
        }
        int end = 0;
        int lastPos = value.length() - 1;
        char c = value.charAt(lastPos - end);
        if (c == 'i') {
            throw new IllegalArgumentException("Invalid format [" + size + "], cannot end with \"i\".");
        }
        if (c == 'B') {
            c = value.charAt(lastPos - ++end);
            boolean flag = this.isBlank(c);
            while (this.isBlank(c) && end < lastPos) {
                c = value.charAt(lastPos - ++end);
            }
            if (flag && !Character.isDigit(c)) {
                throw new IllegalArgumentException("Invalid format [" + size + "]: \"" + c + "\".");
            }
        }
        if (!Character.isDigit(c)) {
            if (c == 'i') {
                if (this == SI) {
                    throw new IllegalArgumentException("Invalid SI format [" + size + "], cannot contains \"i\".");
                }
                c = value.charAt(lastPos - ++end);
            } else if (this == BINARY && strict) {
                throw new IllegalArgumentException("Invalid BINARY format [" + size + "], miss character \"i\".");
            }
            switch (c) {
                case 'K': {
                    factor = this.sizes[1];
                    break;
                }
                case 'M': {
                    factor = this.sizes[2];
                    break;
                }
                case 'G': {
                    factor = this.sizes[3];
                    break;
                }
                case 'T': {
                    factor = this.sizes[4];
                    break;
                }
                case 'P': {
                    factor = this.sizes[5];
                    break;
                }
                case 'E': {
                    factor = this.sizes[6];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid format [" + size + "]: \"" + c + "\".");
                }
            }
            while (this.isBlank(c = value.charAt(lastPos - ++end)) && end < lastPos) {
            }
        }
        value = value.substring(0, value.length() - end);
        try {
            return (long)sign * (long)((double)factor * new DecimalFormat(FORMAT).parse(value).doubleValue());
        }
        catch (NumberFormatException | ParseException e) {
            throw new IllegalArgumentException("Failed to parse [" + size + "]: \"" + value + "\".");
        }
    }

    public int base() {
        return this.base;
    }

    public String[] units() {
        return Arrays.copyOf(this.units, this.units.length);
    }

    public long[] sizes() {
        return Arrays.copyOf(this.sizes, this.sizes.length);
    }

    private int find(long bytes) {
        int n = this.sizes.length;
        for (int i = 1; i < n; ++i) {
            if (bytes >= this.sizes[i]) continue;
            return i - 1;
        }
        return n - 1;
    }

    private boolean isBlank(char c) {
        return c == ' ' || c == '\t';
    }

    static {
        PATTERN = Pattern.compile(".*[0-9]+.*");
    }
}

