/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce;

import com.google.common.collect.ImmutableBiMap;

public enum HmacAlgorithms {
    HmacMD5(128),
    HmacRipeMD128(128),
    HmacRipeMD160(160),
    HmacRipeMD256(256),
    HmacRipeMD320(320),
    HmacSHA1(160),
    HmacSHA224(224),
    HmacSHA256(256),
    HmacSHA384(384),
    HmacSHA512(512),
    HmacKECCAK224(224),
    HmacKECCAK288(288),
    HmacKECCAK256(256),
    HmacKECCAK384(384),
    HmacKECCAK512(512),
    HmacSKEIN_256_128("Skein-MAC-256-128", 128),
    HmacSKEIN_256_256("Skein-MAC-256-256", 256),
    HmacSKEIN_512_256("Skein-MAC-512-256", 256),
    HmacSKEIN_512_512("Skein-MAC-512-512", 512),
    HmacSKEIN_1024_512("Skein-MAC-1024-512", 512),
    HmacSKEIN_1024_1024("Skein-MAC-1024-1024", 1024),
    HmacSHA3_224("HmacSHA3-224", 224),
    HmacSHA3_256("HmacSHA3-256", 256),
    HmacSHA3_384("HmacSHA3-384", 384),
    HmacSHA3_512("HmacSHA3-512", 512);

    private final String algorithm;
    private final int byteSize;
    public static final ImmutableBiMap<Integer, HmacAlgorithms> ALGORITHM_MAPPING;

    private HmacAlgorithms(int bitLen) {
        this.algorithm = this.name();
        this.byteSize = bitLen >>> 3;
    }

    private HmacAlgorithms(String algorithm, int bitLen) {
        this.algorithm = algorithm;
        this.byteSize = bitLen >>> 3;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public int byteSize() {
        return this.byteSize;
    }

    static {
        ALGORITHM_MAPPING = ImmutableBiMap.builder().put((Object)1, (Object)HmacSHA256).put((Object)2, (Object)HmacSHA512).put((Object)3, (Object)HmacKECCAK256).put((Object)4, (Object)HmacKECCAK512).put((Object)5, (Object)HmacSHA3_256).put((Object)6, (Object)HmacSHA3_512).build();
    }
}

