/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.cert;

import cn.ponfee.commons.jce.cert.X509CertInfo;
import cn.ponfee.commons.jce.cert.X509CertUtils;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class CertSignedVerifier {
    protected final X509Certificate rootCert;
    protected final X509CRL crl;
    protected final byte[] info;
    protected final List<byte[]> signedInfos = new ArrayList<byte[]>();
    protected X509Certificate[] subjects;
    private boolean verifySigned = true;

    protected CertSignedVerifier(X509Certificate rootCert, X509CRL crl, byte[] info) {
        this.rootCert = rootCert;
        this.crl = crl;
        this.info = info;
    }

    public final void verify() {
        for (X509Certificate subject : this.subjects) {
            String subjectCN = X509CertUtils.getCertInfo(subject, X509CertInfo.SUBJECT_CN);
            if (this.rootCert == null) {
                throw new SecurityException("[" + subjectCN + "]\u7684\u6839\u8bc1\u672a\u53d7\u4fe1\u4efb");
            }
            CertSignedVerifier.verifyCertDate(subject);
            CertSignedVerifier.verifyIssuingSign(subject, this.rootCert);
            if (this.crl == null) continue;
            CertSignedVerifier.verifyCrlRevoke(subject, this.crl);
        }
        if (this.verifySigned) {
            this.verifySigned();
        }
    }

    public abstract void verifySigned();

    public static void verifyCertDate(X509Certificate subject) {
        String subjectCN = null;
        try {
            subjectCN = X509CertUtils.getCertInfo(subject, X509CertInfo.SUBJECT_CN);
            subject.checkValidity(new Date());
        }
        catch (CertificateExpiredException e) {
            throw new SecurityException("[" + subjectCN + "]\u5df2\u8fc7\u671f", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new SecurityException("[" + subjectCN + "]\u5c1a\u672a\u751f\u6548", e);
        }
    }

    public static void verifyIssuingSign(X509Certificate subject, X509Certificate root) {
        String subjectCN = null;
        try {
            subjectCN = X509CertUtils.getCertInfo(subject, X509CertInfo.SUBJECT_CN);
            subject.verify(root.getPublicKey());
        }
        catch (SignatureException e) {
            throw new SecurityException("[" + subjectCN + "]\u7684\u6839\u8bc1\u672a\u53d7\u4fe1\u4efb", e);
        }
        catch (Exception e) {
            throw new SecurityException("\u6839\u8bc1\u9a8c\u7b7e\u51fa\u9519", e);
        }
    }

    public static void verifyCrlRevoke(X509Certificate subject, X509CRL crl) {
        String subjectCN = X509CertUtils.getCertInfo(subject, X509CertInfo.SUBJECT_CN);
        if (crl.isRevoked(subject)) {
            throw new SecurityException("[" + subjectCN + "]\u5df2\u88ab\u540a\u9500");
        }
    }

    public X509Certificate[] getSubjects() {
        return this.subjects;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public List<byte[]> getSignedInfo() {
        return this.signedInfos;
    }

    public void setVerifySigned(boolean verifySigned) {
        this.verifySigned = verifySigned;
    }
}

