/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.cert;

import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.RSASignAlgorithms;
import cn.ponfee.commons.util.ObjectUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Vector;
import javax.annotation.Nullable;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import sun.security.pkcs10.PKCS10;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class X509CertGenerator {
    public static X509Certificate createRootCert(String issuer, RSASignAlgorithms sigAlg, PrivateKey privateKey, PublicKey publicKey, Date notBefore, Date notAfter) {
        return X509CertGenerator.createRootCert(null, issuer, sigAlg, privateKey, publicKey, notBefore, notAfter);
    }

    public static X509Certificate createRootCert(BigInteger sn, String issuer, RSASignAlgorithms sigAlg, PrivateKey privateKey, PublicKey publicKey, Date notBefore, Date notAfter) {
        PKCS10 pkcs10 = X509CertGenerator.createPkcs10(issuer, privateKey, publicKey, sigAlg);
        X509CertInfo certInfo = X509CertGenerator.createCertInfo(sn, pkcs10, notBefore, notAfter, X509CertGenerator.createExtensions(true));
        return X509CertGenerator.selfSign(privateKey, certInfo);
    }

    public static X509Certificate createSubjectCert(X509Certificate caCert, PrivateKey caKey, String subject, RSASignAlgorithms sigAlg, PrivateKey privateKey, PublicKey publicKey, Date notBefore, Date notAfter) {
        return X509CertGenerator.createSubjectCert(caCert, caKey, null, subject, sigAlg, privateKey, publicKey, notBefore, notAfter);
    }

    public static X509Certificate createSubjectCert(X509Certificate caCert, PrivateKey caKey, BigInteger sn, String subject, RSASignAlgorithms sigAlg, PrivateKey privateKey, PublicKey publicKey, Date notBefore, Date notAfter) {
        PKCS10 pkcs10 = X509CertGenerator.createPkcs10(subject, privateKey, publicKey, sigAlg);
        X509CertInfo certInfo = X509CertGenerator.createCertInfo(sn, pkcs10, notBefore, notAfter, X509CertGenerator.createExtensions(false));
        return X509CertGenerator.caSign(caCert, caKey, certInfo);
    }

    public static X509Certificate createSubjectCert(X509Certificate caCert, PrivateKey caKey, PKCS10 pkcs10, Date notBefore, Date notAfter) {
        return X509CertGenerator.createSubjectCert(caCert, caKey, null, pkcs10, notBefore, notAfter);
    }

    public static X509Certificate createSubjectCert(X509Certificate caCert, PrivateKey caKey, BigInteger sn, PKCS10 pkcs10, Date notBefore, Date notAfter) {
        X509CertInfo certInfo = X509CertGenerator.createCertInfo(sn, pkcs10, notBefore, notAfter, X509CertGenerator.createExtensions(false));
        return X509CertGenerator.caSign(caCert, caKey, certInfo);
    }

    public static PKCS10 createPkcs10(String subject, PrivateKey privateKey, PublicKey publicKey, RSASignAlgorithms sigAlg) {
        Signature signature = Providers.getSignature(sigAlg.name());
        try {
            PKCS10 pkcs10 = new PKCS10(publicKey);
            signature.initSign(privateKey);
            pkcs10.encodeAndSign(new X500Name(subject), signature);
            return pkcs10;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static CertificateExtensions createExtensions(boolean isCA) {
        try {
            CertificateExtensions extensions = new CertificateExtensions();
            KeyUsageExtension keyUsage = new KeyUsageExtension();
            keyUsage.set("digital_signature", true);
            if (isCA) {
                keyUsage.set("key_encipherment", true);
                keyUsage.set("key_agreement", true);
                keyUsage.set("key_certsign", true);
                keyUsage.set("crl_sign", true);
            } else {
                keyUsage.set("data_encipherment", true);
                Vector<ObjectIdentifier> extendedKeyUsage = new Vector<ObjectIdentifier>();
                extendedKeyUsage.add(new ObjectIdentifier(new int[]{1, 3, 6, 1, 5, 5, 7, 3, 3}));
                extensions.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension(extendedKeyUsage));
            }
            extensions.set("KeyUsage", keyUsage);
            return extensions;
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    private static X509CertInfo createCertInfo(@Nullable BigInteger sn, PKCS10 pkcs10, Date notBefore, Date notAfter, CertificateExtensions extensions) {
        if (sn == null) {
            sn = new BigInteger(1, ObjectUtils.uuid());
        }
        try {
            PKCS10CertificationRequest req = new PKCS10CertificationRequest(pkcs10.getEncoded());
            JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();
            builder.setProvider(Providers.BC);
            if (!req.isSignatureValid(builder.build(req.getSubjectPublicKeyInfo()))) {
                throw new SecurityException("Invalid pkcs10 signature data.");
            }
            AlgorithmId signAlg = AlgorithmId.get(req.getSignatureAlgorithm().getAlgorithm().getId());
            X509CertInfo x509certInfo = new X509CertInfo();
            x509certInfo.set("version", new CertificateVersion(2));
            x509certInfo.set("serialNumber", new CertificateSerialNumber(sn));
            x509certInfo.set("algorithmID", new CertificateAlgorithmId(signAlg));
            x509certInfo.set("subject", pkcs10.getSubjectName());
            x509certInfo.set("key", new CertificateX509Key(pkcs10.getSubjectPublicKeyInfo()));
            x509certInfo.set("validity", new CertificateValidity(notBefore, notAfter));
            if (extensions != null) {
                x509certInfo.set("extensions", extensions);
            }
            return x509certInfo;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    private static X509Certificate selfSign(PrivateKey caKey, X509CertInfo caCertInfo) {
        try {
            CertificateAlgorithmId algId = (CertificateAlgorithmId)caCertInfo.get("algorithmID");
            caCertInfo.set("issuer", caCertInfo.get("subject"));
            X509CertImpl signedCert = new X509CertImpl(caCertInfo);
            signedCert.sign(caKey, algId.get("algorithm").getName());
            return signedCert;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    private static X509Certificate caSign(X509Certificate caCert, PrivateKey caKey, X509CertInfo subjectCertInfo) {
        try {
            X509CertImpl caCertImpl = new X509CertImpl(caCert.getEncoded());
            X509CertInfo caCertInfo = (X509CertInfo)caCertImpl.get("x509.info");
            X500Name issuer = (X500Name)caCertInfo.get("subject.dname");
            subjectCertInfo.set("issuer", issuer);
            X509CertImpl signedCert = new X509CertImpl(subjectCertInfo);
            signedCert.sign(caKey, caCert.getSigAlgName());
            return signedCert;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }
}

