/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.implementation.ecc;

import cn.ponfee.commons.jce.HmacAlgorithms;
import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.digest.HmacUtils;
import cn.ponfee.commons.jce.implementation.Cryptor;
import cn.ponfee.commons.jce.implementation.Key;
import cn.ponfee.commons.jce.implementation.ecc.ECKey;
import cn.ponfee.commons.jce.implementation.ecc.ECPoint;
import cn.ponfee.commons.jce.implementation.ecc.EllipticCurve;
import cn.ponfee.commons.util.Bytes;
import cn.ponfee.commons.util.SecureRandoms;
import java.math.BigInteger;
import java.util.Arrays;

public class ECCryptor
extends Cryptor {
    private static final HmacAlgorithms HMAC_ALG = HmacAlgorithms.HmacSHA3_512;
    private final EllipticCurve curve;

    public ECCryptor(EllipticCurve curve) {
        this.curve = curve;
    }

    @Override
    public byte[] encrypt(byte[] input, int length, Key ek) {
        ECKey ecKey = (ECKey)ek;
        BigInteger rk = ecKey.curve.getN() != null ? SecureRandoms.random(ecKey.curve.getN()) : SecureRandoms.random(ecKey.curve.getP().bitLength() + 17);
        ECPoint gamma = ecKey.curve.getBasePointG().multiply(rk);
        int offset = ecKey.curve.getPCS();
        byte[] result = Arrays.copyOf(gamma.compress(), offset + length);
        ECPoint secure = ecKey.beta.multiply(rk);
        byte[] keyBytes = Bytes.concat(secure.getX().toByteArray(), new byte[][]{secure.getY().toByteArray()});
        int count = 1;
        byte[] hashedKey = HmacUtils.crypt(keyBytes, Bytes.toBytes(count), HMAC_ALG, Providers.BC);
        int keyOffset = 0;
        for (int i = 0; i < length; ++i) {
            if (keyOffset == HMAC_ALG.byteSize()) {
                keyOffset = 0;
                hashedKey = HmacUtils.crypt(keyBytes, Bytes.toBytes(++count), HMAC_ALG, Providers.BC);
            }
            result[i + offset] = (byte)(input[i] ^ hashedKey[keyOffset++]);
        }
        return result;
    }

    @Override
    public byte[] decrypt(byte[] input, Key dk) {
        ECKey ecKey = (ECKey)dk;
        int offset = ecKey.curve.getPCS();
        byte[] gammacom = Arrays.copyOfRange(input, 0, offset);
        ECPoint gamma = new ECPoint(gammacom, ecKey.curve);
        ECPoint secure = gamma.multiply(ecKey.dk);
        byte[] keyBytes = secure.isZero() ? Bytes.concat(BigInteger.ZERO.toByteArray(), new byte[][]{BigInteger.ZERO.toByteArray()}) : Bytes.concat(secure.getX().toByteArray(), new byte[][]{secure.getY().toByteArray()});
        int count = 1;
        int length = input.length - offset;
        byte[] hashedKey = HmacUtils.crypt(keyBytes, Bytes.toBytes(count), HMAC_ALG, Providers.BC);
        byte[] result = new byte[length];
        int keyOffset = 0;
        for (int i = 0; i < length; ++i) {
            if (keyOffset == HMAC_ALG.byteSize()) {
                keyOffset = 0;
                hashedKey = HmacUtils.crypt(keyBytes, Bytes.toBytes(++count), HMAC_ALG, Providers.BC);
            }
            result[i] = (byte)(input[i + offset] ^ hashedKey[keyOffset++]);
        }
        return result;
    }

    @Override
    public Key generateKey() {
        return new ECKey(this.curve);
    }

    public String toString() {
        return "ECCryptor - " + this.curve.toString();
    }
}

