/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.implementation.ecc;

import cn.ponfee.commons.jce.implementation.ecc.EllipticCurve;
import java.math.BigInteger;

public class ECPoint {
    private final EllipticCurve curve;
    private final boolean zero;
    private BigInteger x;
    private BigInteger y;
    private ECPoint[] fastcache = null;

    public void fastCache() {
        if (this.fastcache == null) {
            this.fastcache = new ECPoint[256];
            this.fastcache[0] = new ECPoint(this.curve);
            for (int i = 1; i < this.fastcache.length; ++i) {
                this.fastcache[i] = this.fastcache[i - 1].add(this);
            }
        }
    }

    public ECPoint(EllipticCurve curve, BigInteger x, BigInteger y) {
        this.curve = curve;
        this.x = x;
        this.y = y;
        if (!curve.isOnCurve(this)) {
            throw new IllegalArgumentException("(x,y) is not on this curve!");
        }
        this.zero = false;
    }

    public ECPoint(byte[] bytes, EllipticCurve curve) {
        this.curve = curve;
        if (bytes[0] == 2) {
            this.zero = true;
            return;
        }
        boolean ymt = bytes[0] != 0;
        bytes[0] = 0;
        this.x = new BigInteger(1, bytes);
        this.y = this.x.multiply(this.x).add(curve.getA()).multiply(this.x).add(curve.getB()).modPow(curve.getPSR2(), curve.getP());
        if (ymt != this.y.testBit(0)) {
            this.y = curve.getP().subtract(this.y);
        }
        this.zero = false;
    }

    public ECPoint(EllipticCurve e) {
        this.x = this.y = BigInteger.ZERO;
        this.curve = e;
        this.zero = true;
    }

    public byte[] compress() {
        byte[] cmp = new byte[this.curve.getPCS()];
        if (this.zero) {
            cmp[0] = 2;
        }
        byte[] xb = this.x.toByteArray();
        System.arraycopy(xb, 0, cmp, this.curve.getPCS() - xb.length, xb.length);
        if (this.y.testBit(0)) {
            cmp[0] = 1;
        }
        return cmp;
    }

    public ECPoint add(ECPoint q) {
        BigInteger alpha;
        if (!this.isSameCurve(q)) {
            throw new IllegalArgumentException("the q point don't lie on the same elliptic curve.");
        }
        if (this.isZero()) {
            return q;
        }
        if (q.isZero()) {
            return this;
        }
        BigInteger x1 = this.x;
        BigInteger y1 = this.y;
        BigInteger x2 = q.getX();
        BigInteger y2 = q.getY();
        if (x2.compareTo(x1) == 0) {
            if (y2.compareTo(y1) != 0) {
                return new ECPoint(this.curve);
            }
            alpha = x1.modPow(EllipticCurve.TWO, this.curve.getP()).multiply(EllipticCurve.THREE).add(this.curve.getA());
            alpha = alpha.multiply(EllipticCurve.TWO.multiply(y1).modInverse(this.curve.getP())).mod(this.curve.getP());
        } else {
            BigInteger i = x2.subtract(x1).modInverse(this.curve.getP());
            alpha = y2.subtract(y1).multiply(i).mod(this.curve.getP());
        }
        BigInteger x3 = alpha.modPow(EllipticCurve.TWO, this.curve.getP()).subtract(x2).subtract(x1).mod(this.curve.getP());
        BigInteger y3 = alpha.multiply(x1.subtract(x3)).subtract(y1).mod(this.curve.getP());
        return new ECPoint(this.curve, x3, y3);
    }

    public ECPoint multiply(BigInteger k) {
        ECPoint result = this;
        for (int i = k.bitCount() - 1; i > 0; --i) {
            result = result.add(result);
            if (!k.testBit(i)) continue;
            result = result.add(this);
        }
        return result;
    }

    public boolean isZero() {
        return this.zero;
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public EllipticCurve getCurve() {
        return this.curve;
    }

    public String toString() {
        return "(" + this.x.toString() + ", " + this.y.toString() + ")";
    }

    private boolean isSameCurve(ECPoint p) {
        return this.curve.equals(p.getCurve());
    }
}

