/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.implementation.ecc;

import cn.ponfee.commons.jce.ECParameters;
import cn.ponfee.commons.jce.implementation.ecc.ECPoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EllipticCurve {
    public static final BigInteger COEFA = new BigInteger("4");
    public static final BigInteger COEFB = new BigInteger("27");
    public static final BigInteger TWO = new BigInteger("2");
    public static final BigInteger THREE = new BigInteger("3");
    private static final int PRIME_SECURITY = 500;
    private final BigInteger a;
    private final BigInteger b;
    private final BigInteger p;
    private final BigInteger n;
    private final String name;
    private final int pcs;
    private final ECPoint basePointG;
    private BigInteger psr2;

    public EllipticCurve(BigInteger a, BigInteger b, BigInteger p) {
        if (!p.isProbablePrime(500)) {
            throw new IllegalArgumentException("the p is not prime");
        }
        if (EllipticCurve.isSingular(a, b, p)) {
            throw new IllegalArgumentException("is singular");
        }
        this.a = a;
        this.b = b;
        this.p = p;
        this.name = "cust";
        byte[] p0 = p.toByteArray();
        this.pcs = p0[0] == 0 ? p0.length : p0.length + 1;
        this.n = this.calculateN();
        this.basePointG = this.calculateBasePointG();
    }

    public EllipticCurve(ECParameters ecp) {
        if (!ecp.p.isProbablePrime(500)) {
            throw new IllegalArgumentException("the p is not prime");
        }
        if (EllipticCurve.isSingular(ecp.a, ecp.b, ecp.p)) {
            throw new IllegalArgumentException("the ec parameter is singular");
        }
        this.a = ecp.a;
        this.b = ecp.b;
        this.p = ecp.p;
        this.name = ecp.toString();
        byte[] p0 = ecp.p.toByteArray();
        this.pcs = p0[0] == 0 ? p0.length : p0.length + 1;
        this.n = ecp.n;
        this.basePointG = new ECPoint(this, ecp.gx, ecp.gy);
        this.basePointG.fastCache();
    }

    public EllipticCurve(DataInputStream input) throws IOException {
        byte[] ab = new byte[input.readInt()];
        input.read(ab);
        this.a = new BigInteger(1, ab);
        byte[] bb = new byte[input.readInt()];
        input.read(bb);
        this.b = new BigInteger(1, bb);
        byte[] pb = new byte[input.readInt()];
        input.read(pb);
        this.p = new BigInteger(1, pb);
        byte[] ob = new byte[input.readInt()];
        input.read(ob);
        this.n = new BigInteger(1, ob);
        byte[] gb = new byte[input.readInt()];
        input.read(gb);
        this.basePointG = new ECPoint(gb, this);
        byte[] ppb = new byte[input.readInt()];
        input.read(ppb);
        this.psr2 = new BigInteger(1, ppb);
        this.pcs = input.readInt();
        this.name = input.readUTF();
        this.basePointG.fastCache();
    }

    public void writeCurve(DataOutputStream output) throws IOException {
        byte[] a0 = this.a.toByteArray();
        output.writeInt(a0.length);
        output.write(a0);
        byte[] b0 = this.b.toByteArray();
        output.writeInt(b0.length);
        output.write(b0);
        byte[] p0 = this.p.toByteArray();
        output.writeInt(p0.length);
        output.write(p0);
        byte[] n0 = this.n.toByteArray();
        output.writeInt(n0.length);
        output.write(n0);
        byte[] pointG0 = this.basePointG.compress();
        output.writeInt(pointG0.length);
        output.write(pointG0);
        byte[] ppobf0 = this.getPSR2().toByteArray();
        output.writeInt(ppobf0.length);
        output.write(ppobf0);
        output.writeInt(this.pcs);
        output.writeUTF(this.name);
    }

    public boolean isOnCurve(ECPoint q) {
        BigInteger xCube;
        BigInteger dum;
        if (q.isZero()) {
            return true;
        }
        BigInteger ySquare = q.getY().modPow(TWO, this.p);
        return ySquare.compareTo(dum = (xCube = q.getX().modPow(THREE, this.p)).add(this.a.multiply(q.getX())).add(this.b).mod(this.p)) == 0;
    }

    public BigInteger getN() {
        return this.n;
    }

    public ECPoint getZero() {
        return new ECPoint(this);
    }

    public BigInteger getA() {
        return this.a;
    }

    public BigInteger getB() {
        return this.b;
    }

    public BigInteger getP() {
        return this.p;
    }

    public int getPCS() {
        return this.pcs;
    }

    public ECPoint getBasePointG() {
        return this.basePointG;
    }

    public BigInteger getPSR2() {
        if (this.psr2 == null) {
            this.psr2 = this.p.add(BigInteger.ONE).shiftRight(2);
        }
        return this.psr2;
    }

    public String toString() {
        if (this.name == null || this.name.length() == 0) {
            return "y^2 = x^3 + " + this.a + "x + " + this.b + " ( mod " + this.p + " )";
        }
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EllipticCurve)) {
            return false;
        }
        EllipticCurve o = (EllipticCurve)obj;
        return new EqualsBuilder().append((Object)this.a, (Object)o.a).append((Object)this.b, (Object)o.b).append((Object)this.p, (Object)o.p).append((Object)this.n, (Object)o.n).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.a).append((Object)this.b).append((Object)this.p).append((Object)this.n).hashCode();
    }

    private static boolean isSingular(BigInteger a, BigInteger b, BigInteger p) {
        BigInteger a0 = a.pow(3);
        BigInteger b0 = b.pow(2);
        BigInteger result = a0.multiply(COEFA).add(b0.multiply(COEFB)).mod(p);
        return result.compareTo(BigInteger.ZERO) == 0;
    }

    private BigInteger calculateN() {
        return null;
    }

    private ECPoint calculateBasePointG() {
        return null;
    }
}

