/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.passwd;

import cn.ponfee.commons.jce.HmacAlgorithms;
import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.util.Base64UrlSafe;
import cn.ponfee.commons.util.SecureRandoms;
import com.google.common.base.Preconditions;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class PBKDF2 {
    private static final char SEPARATOR = '$';

    private PBKDF2() {
    }

    public static String create(String password) {
        return PBKDF2.create(HmacAlgorithms.HmacSHA256, password.toCharArray());
    }

    public static String create(HmacAlgorithms alg, String password) {
        return PBKDF2.create(alg, password.toCharArray());
    }

    public static String create(HmacAlgorithms alg, char[] password) {
        return PBKDF2.create(alg, password, 16, 32, 32);
    }

    public static String create(HmacAlgorithms alg, char[] password, int saltByteSize, int iterationCount, int dkLen) {
        Preconditions.checkArgument((iterationCount >= 1 && iterationCount <= 65535 ? 1 : 0) != 0, (Object)"iterations must between 1 and 65535");
        byte[] salt = SecureRandoms.nextBytes(saltByteSize);
        byte[] hash = PBKDF2.pbkdf2(alg, password, salt, iterationCount, dkLen);
        int algIdx = (Integer)HmacAlgorithms.ALGORITHM_MAPPING.inverse().get((Object)alg) & 0xF;
        String params = Integer.toString(algIdx << 16 | iterationCount, 16);
        return new StringBuilder(8 + (salt.length + hash.length << 2) / 3 + 4).append('$').append(params).append('$').append(Base64UrlSafe.encode(salt)).append('$').append(Base64UrlSafe.encode(hash)).toString();
    }

    public static boolean check(String password, String correctHash) {
        return PBKDF2.check(password.toCharArray(), correctHash);
    }

    public static boolean check(char[] password, String correctHash) {
        String[] parts = correctHash.split("\\$");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid hashed value");
        }
        int params = Integer.parseInt(parts[1], 16);
        HmacAlgorithms alg = (HmacAlgorithms)((Object)HmacAlgorithms.ALGORITHM_MAPPING.get((Object)(params >> 16 & 0xF)));
        int iterations = params & 0xFFFF;
        byte[] salt = Base64UrlSafe.decode(parts[2]);
        byte[] hash = Base64UrlSafe.decode(parts[3]);
        byte[] testHash = PBKDF2.pbkdf2(alg, password, salt, iterations, hash.length);
        return Arrays.equals(hash, testHash);
    }

    public static byte[] pbkdf2(HmacAlgorithms alg, char[] password, byte[] salt, int iterationCount, int dkLen) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterationCount, dkLen << 3);
        try {
            SecretKeyFactory skf = Providers.getSecretKeyFactory("PBKDF2With" + alg.algorithm());
            return skf.generateSecret(spec).getEncoded();
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }
}

