/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.pkcs;

import cn.ponfee.commons.jce.Providers;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public final class CryptoMessageSyntax {
    public static byte[] sign(byte[] data, PrivateKey key, X509Certificate[] certChain) {
        return CryptoMessageSyntax.sign(data, Collections.singletonList(key), Collections.singletonList(certChain));
    }

    public static byte[] sign(byte[] data, List<PrivateKey> keys, List<X509Certificate[]> certs) {
        try {
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(Providers.BC).build();
            for (int i = 0; i < keys.size(); ++i) {
                gen.addCertificates((Store)new JcaCertStore(Arrays.asList((Object[])certs.get(i))));
                ContentSigner signer = new JcaContentSignerBuilder(certs.get(i)[0].getSigAlgName()).setProvider(Providers.BC).build(keys.get(i));
                JcaSignerInfoGeneratorBuilder jsBuilder = new JcaSignerInfoGeneratorBuilder(dcp);
                gen.addSignerInfoGenerator(jsBuilder.build(signer, certs.get(i)[0]));
            }
            return gen.generate((CMSTypedData)new CMSProcessableByteArray(data), true).getEncoded();
        }
        catch (IOException | CertificateEncodingException | CMSException | OperatorCreationException e) {
            throw new SecurityException(e);
        }
    }

    public static void verify(byte[] signed) {
        try {
            CMSSignedData sign = new CMSSignedData(signed);
            Store store = sign.getCertificates();
            JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder().setProvider(Providers.BC);
            for (SignerInformation signer : sign.getSignerInfos()) {
                Collection chain;
                X509CertificateHolder cert;
                if (signer.verify(builder.build(cert = (X509CertificateHolder)(chain = store.getMatches((Selector)signer.getSID())).iterator().next()))) continue;
                String sn = Hex.encodeHexString((byte[])cert.getSerialNumber().toByteArray());
                String dn = cert.getSubject().toString();
                throw new SecurityException("signature verify fail[" + sn + ", " + dn + "]");
            }
        }
        catch (CertificateException | CMSException | OperatorCreationException e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] envelop(byte[] data, X509Certificate cert, ASN1ObjectIdentifier alg) {
        try {
            CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
            edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider(Providers.BC));
            return edGen.generate((CMSTypedData)new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(alg).setProvider(Providers.BC).build()).getEncoded();
        }
        catch (IOException | CertificateEncodingException | CMSException e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] unenvelop(byte[] enveloped, X509Certificate cert, PrivateKey privateKey) {
        try {
            RecipientInformationStore ris = new CMSEnvelopedData(enveloped).getRecipientInfos();
            for (RecipientInformation rin : ris.getRecipients()) {
                KeyTransRecipientId rid = (KeyTransRecipientId)rin.getRID();
                if (!cert.getSerialNumber().equals(rid.getSerialNumber())) continue;
                return rin.getContent((Recipient)new JceKeyTransEnvelopedRecipient(privateKey).setProvider(Providers.BC));
            }
            return null;
        }
        catch (CMSException e) {
            throw new SecurityException(e);
        }
    }
}

