/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.pkcs;

import cn.ponfee.commons.jce.Providers;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;

public class PKCS1Signature {
    public static byte[] sign(byte[] data, PrivateKey privateKey, X509Certificate cert) {
        Signature signature = Providers.getSignature(cert.getSigAlgName());
        try {
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException(e);
        }
    }

    public static boolean verify(byte[] data, byte[] signed, X509Certificate cert) {
        Signature sign = Providers.getSignature(cert.getSigAlgName());
        try {
            sign.initVerify(cert.getPublicKey());
            sign.update(data);
            return sign.verify(signed);
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException(e);
        }
    }
}

