/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.pkcs;

import cn.ponfee.commons.jce.Providers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Hex;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class PKCS7Signature {
    public static byte[] sign(PrivateKey privKey, X509Certificate cert, byte[] data, boolean attach) {
        return PKCS7Signature.sign(new PrivateKey[]{privKey}, new X509Certificate[]{cert}, data, attach);
    }

    public static byte[] sign(PrivateKey[] privKeys, X509Certificate[] certs, byte[] data, boolean attach) {
        ContentInfo contentInfo = attach ? new ContentInfo(data) : new ContentInfo(ContentInfo.DATA_OID, null);
        return PKCS7Signature.sign(contentInfo, data, certs, privKeys);
    }

    public static byte[] sign(PrivateKey privKey, X509Certificate cert, String data, boolean attach) {
        return PKCS7Signature.sign(new PrivateKey[]{privKey}, new X509Certificate[]{cert}, data, attach);
    }

    public static byte[] sign(PrivateKey[] privKeys, X509Certificate[] certs, String data, boolean attach) {
        try {
            DerValue dv = null;
            if (attach) {
                dv = new DerValue(data);
            }
            ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, dv);
            return PKCS7Signature.sign(contentInfo, data.getBytes(), certs, privKeys);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] verify(byte[] pkcs7Data) {
        PKCS7 pkcs7 = PKCS7Signature.getPkcs7(pkcs7Data);
        byte[] data = PKCS7Signature.getContent(pkcs7);
        PKCS7Signature.verify(pkcs7, data);
        return data;
    }

    public static void verify(byte[] pkcs7Data, byte[] data) {
        PKCS7Signature.verify(PKCS7Signature.getPkcs7(pkcs7Data), data);
    }

    public static void verify(PKCS7 pkcs7, byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("the origin data cannot be null.");
        }
        try {
            for (SignerInfo signed : pkcs7.getSignerInfos()) {
                if (pkcs7.verify(signed, data) != null) continue;
                String certSN = Hex.encodeHexString((byte[])signed.getCertificateSerialNumber().toByteArray());
                String subjectDN = signed.getCertificate(pkcs7).getSubjectX500Principal().getName();
                throw new SecurityException("\u9a8c\u7b7e\u5931\u8d25[certSN\uff1a" + certSN + "\uff1bsubjectDN\uff1a" + subjectDN + "]");
            }
        }
        catch (IOException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] sign(ContentInfo contentInfo, byte[] data, X509Certificate[] certs, PrivateKey[] keys) {
        SignerInfo[] signs = new SignerInfo[keys.length];
        AlgorithmId[] digestAlgorithmIds = new AlgorithmId[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            X509Certificate cert = certs[i];
            PrivateKey privKey = keys[i];
            try {
                AlgorithmId digAlg = AlgorithmId.get(AlgorithmId.getDigAlgFromSigAlg((String)cert.getSigAlgName()));
                AlgorithmId encAlg = AlgorithmId.get(AlgorithmId.getEncAlgFromSigAlg((String)cert.getSigAlgName()));
                digestAlgorithmIds[i] = digAlg;
                X500Name name = new X500Name(cert.getIssuerX500Principal().getEncoded());
                Signature signer = Providers.getSignature(cert.getSigAlgName());
                signer.initSign(privKey);
                signer.update(data);
                signs[i] = new SignerInfo(name, cert.getSerialNumber(), digAlg, encAlg, signer.sign());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        PKCS7 pkcs7 = new PKCS7(digestAlgorithmIds, contentInfo, certs, signs);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            pkcs7.encodeSignedData(out);
            out.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PKCS7 getPkcs7(byte[] pkcs7Data) {
        try {
            return new PKCS7(pkcs7Data);
        }
        catch (ParsingException e) {
            throw new IllegalArgumentException("Invalid pacs7 data", e);
        }
    }

    public static byte[] getContent(PKCS7 pkcs7) {
        ContentInfo contentInfo = pkcs7.getContentInfo();
        try {
            byte[] data;
            if (contentInfo.getContent() == null) {
                data = contentInfo.getData();
            } else {
                try {
                    data = contentInfo.getContent().getOctetString();
                }
                catch (Exception e) {
                    data = contentInfo.getContent().getDataBytes();
                }
            }
            return data;
        }
        catch (IOException e) {
            throw new SecurityException("Get content from pkcs7 occur error", e);
        }
    }
}

