/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.security;

import cn.ponfee.commons.jce.Providers;
import cn.ponfee.commons.jce.cert.X509CertUtils;
import cn.ponfee.commons.jce.digest.DigestUtils;
import cn.ponfee.commons.util.SecureRandoms;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeyStoreResolver {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom(SecureRandoms.generateSeed(20));
    private final KeyStore keyStore;

    public KeyStoreResolver(KeyStoreType type) {
        this(type, null);
    }

    public KeyStoreResolver(KeyStoreType type, String storePassword) {
        this(type, (InputStream)null, storePassword);
    }

    public KeyStoreResolver(KeyStoreType type, byte[] keyStore, String storePassword) {
        this(type, new ByteArrayInputStream(keyStore), storePassword);
    }

    public KeyStoreResolver(KeyStoreType type, InputStream input, String storePassword) {
        this.keyStore = Providers.getKeyStore(type.name());
        try (InputStream inputStream = input;){
            this.keyStore.load(inputStream, KeyStoreResolver.toCharArray(storePassword));
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public void setCertificateEntry(String alias, Certificate cert) {
        try {
            this.checkAliasNotExists(alias);
            this.keyStore.setCertificateEntry(alias, cert);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public final void setKeyEntry(String alias, PrivateKey key, String keyPassword, Certificate[] chain) {
        try {
            this.checkAliasNotExists(alias);
            this.keyStore.setKeyEntry(alias, key, keyPassword.toCharArray(), chain);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public final void setKeyEntry(String alias, byte[] encryptedPkcs8Key, Certificate[] chain) {
        try {
            this.checkAliasNotExists(alias);
            this.keyStore.setKeyEntry(alias, encryptedPkcs8Key, chain);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public byte[] export(String storePassword) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.export(out, storePassword);
        return out.toByteArray();
    }

    public void export(OutputStream out, String storePassword) {
        try {
            this.keyStore.store(out, KeyStoreResolver.toCharArray(storePassword));
            out.flush();
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public List<String> listAlias() {
        try {
            ArrayList<String> alias = new ArrayList<String>();
            Enumeration<String> e = this.keyStore.aliases();
            while (e.hasMoreElements()) {
                alias.add(e.nextElement());
            }
            return alias;
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public void delAlias(String alias) {
        try {
            if (this.keyStore.containsAlias(alias)) {
                this.keyStore.deleteEntry(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public String getFirstAlias() {
        try {
            return this.keyStore.aliases().nextElement();
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public Certificate getCertificate() {
        return this.getCertificate(this.getFirstAlias());
    }

    public Certificate getCertificate(String alias) {
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public PrivateKey getPrivateKey(String keyPassword) {
        return this.getPrivateKey(this.getFirstAlias(), keyPassword);
    }

    public PrivateKey getPrivateKey(String alias, String keyPassword) {
        try {
            if (!this.keyStore.isKeyEntry(alias)) {
                throw new SecurityException("alias[" + alias + "] is not key entry.");
            }
            return (PrivateKey)this.keyStore.getKey(alias, KeyStoreResolver.toCharArray(keyPassword));
        }
        catch (UnrecoverableKeyException e) {
            throw new SecurityException("invalid key password: " + keyPassword, e);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    public X509Certificate[] getX509CertChain() {
        return this.getX509CertChain(this.getFirstAlias());
    }

    public X509Certificate[] getX509CertChain(String alias) {
        try {
            if (!this.keyStore.isKeyEntry(alias)) {
                throw new SecurityException("alias[" + alias + "] is not key entry.");
            }
            Certificate[] certs = this.keyStore.getCertificateChain(alias);
            X509Certificate[] x509Certchain = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509Certchain[i] = (X509Certificate)certs[i];
            }
            return x509Certchain;
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
    }

    public SSLContext getSSLContext(String keyPassword) {
        return this.getSSLContext(keyPassword, null);
    }

    public SSLContext getSSLContext(String keyPassword, KeyStore trustStore) {
        String algorithm = "SunX509";
        try {
            TrustManager[] trusts = null;
            if (trustStore != null) {
                TrustManagerFactory tmf = Providers.getTrustManagerFactory(algorithm);
                tmf.init(trustStore);
                trusts = tmf.getTrustManagers();
            }
            KeyManagerFactory kmf = Providers.getKeyManagerFactory(algorithm);
            kmf.init(this.keyStore, KeyStoreResolver.toCharArray(keyPassword));
            SSLContext context = Providers.getSSLContext("TLS");
            context.init(kmf.getKeyManagers(), trusts, SECURE_RANDOM);
            return context;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new SecurityException(e);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public static KeyStoreResolver loadFromPem(String pem) {
        KeyStoreResolver resolver = new KeyStoreResolver(KeyStoreType.JKS);
        resolver.setCertificateEntry(DigestUtils.md5Hex(pem), X509CertUtils.loadPemCert(pem));
        return resolver;
    }

    private void checkAliasNotExists(String alias) throws KeyStoreException {
        if (this.keyStore.containsAlias(alias)) {
            throw new SecurityException("alias[" + alias + "] is exists.");
        }
    }

    private static char[] toCharArray(String str) {
        if (null == str || str.length() == 0) {
            return null;
        }
        return str.toCharArray();
    }

    public static enum KeyStoreType {
        JKS,
        PKCS12;

    }
}

