/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.jce.sm;

import cn.ponfee.commons.jce.ECParameters;
import cn.ponfee.commons.jce.sm.SM3Digest;
import cn.ponfee.commons.util.Base64UrlSafe;
import cn.ponfee.commons.util.Bytes;
import cn.ponfee.commons.util.SecureRandoms;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public final class SM2 {
    public static final String PRIVATE_KEY = "SM2PrivateKey";
    public static final String PUBLIC_KEY = "SM2PublicKey";
    private static final int KEY_LENGTH = SM3Digest.getDigestSize();
    private final byte[] key = new byte[KEY_LENGTH];
    private final SM3Digest sm3keybase = SM3Digest.getInstance();
    private final SM3Digest sm3c3 = SM3Digest.getInstance();
    private final byte[] x;
    private final byte[] y;
    private byte keyOffset;
    private int count;

    private SM2(ECPoint publicKey, BigInteger privateKey, BigInteger n) {
        Objects.requireNonNull(publicKey, "public key cannot be null.");
        Objects.requireNonNull(privateKey, "private key cannot be null.");
        ECPoint point = publicKey.multiply(privateKey);
        byte[] x1 = point.normalize().getXCoord().toBigInteger().toByteArray();
        byte[] y1 = point.normalize().getYCoord().toBigInteger().toByteArray();
        int byteCount = (int)Math.ceil((double)n.bitLength() / 8.0);
        this.x = new byte[byteCount];
        this.y = new byte[byteCount];
        Bytes.tailCopy(x1, 0, x1.length, this.x, 0, this.x.length);
        Bytes.tailCopy(y1, 0, y1.length, this.y, 0, this.y.length);
        this.reset();
    }

    private void reset() {
        this.sm3keybase.reset();
        this.sm3keybase.update(this.x);
        this.sm3keybase.update(this.y);
        this.sm3c3.reset();
        this.sm3c3.update(this.x);
        this.count = 1;
        this.nextKey();
    }

    private void nextKey() {
        SM3Digest sm3keycur = SM3Digest.getInstance(this.sm3keybase);
        sm3keycur.update(Bytes.toBytes(this.count));
        sm3keycur.doFinal(this.key, 0);
        this.keyOffset = 0;
        ++this.count;
    }

    private void encrypt(byte[] data) {
        this.sm3c3.update(data);
        int i = 0;
        int len = data.length;
        while (i < len) {
            if (this.keyOffset == KEY_LENGTH) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOffset;
            this.keyOffset = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
    }

    private void decrypt(byte[] data) {
        int i = 0;
        int len = data.length;
        while (i < len) {
            if (this.keyOffset == KEY_LENGTH) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOffset;
            this.keyOffset = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
        this.sm3c3.update(data);
    }

    private byte[] doFinal() {
        this.sm3c3.update(this.y);
        byte[] digest = this.sm3c3.doFinal();
        this.reset();
        return digest;
    }

    public static Map<String, byte[]> generateKeyPair() {
        return SM2.generateKeyPair(ECParameters.SM2_BEST);
    }

    public static Map<String, byte[]> generateKeyPair(ECParameters ecParam) {
        AsymmetricCipherKeyPair key = ecParam.keyPairGenerator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger priKey = ecpriv.getD();
        ECPoint pubKey = ecpub.getQ();
        return ImmutableMap.of((Object)PRIVATE_KEY, (Object)priKey.toByteArray(), (Object)PUBLIC_KEY, (Object)pubKey.getEncoded(false));
    }

    public static byte[] getPublicKey(Map<String, byte[]> keyMap) {
        return keyMap.get(PUBLIC_KEY);
    }

    public static byte[] getPrivateKey(Map<String, byte[]> keyMap) {
        return keyMap.get(PRIVATE_KEY);
    }

    public static ECPoint getPublicKey(byte[] publicKey) {
        return SM2.getPublicKey(ECParameters.SM2_BEST, publicKey);
    }

    public static ECPoint getPublicKey(ECParameters ecParam, byte[] publicKey) {
        return ecParam.curve.decodePoint(publicKey);
    }

    public static BigInteger getPrivateKey(byte[] privateKey) {
        return new BigInteger(1, privateKey);
    }

    public static byte[] encrypt(byte[] publicKey, byte[] data) {
        return SM2.encrypt(ECParameters.SM2_BEST, publicKey, data);
    }

    public static byte[] encrypt(ECParameters ecParam, byte[] publicKey, byte[] data) {
        if (ArrayUtils.isEmpty((byte[])publicKey) || ArrayUtils.isEmpty((byte[])data)) {
            return null;
        }
        AsymmetricCipherKeyPair key = ecParam.keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters ecPub = (ECPublicKeyParameters)key.getPublic();
        ECPrivateKeyParameters ecPri = (ECPrivateKeyParameters)key.getPrivate();
        SM2 sm2 = new SM2(ecParam.curve.decodePoint(publicKey), ecPri.getD(), ecParam.n);
        byte[] c1 = ecPub.getQ().getEncoded(false);
        byte[] c2 = Arrays.copyOf(data, data.length);
        sm2.encrypt(c2);
        byte[] c3 = sm2.doFinal();
        return Bytes.concat(c1, c2, c3);
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encrypted) {
        return SM2.decrypt(ECParameters.SM2_BEST, privateKey, encrypted);
    }

    public static byte[] decrypt(ECParameters ecParam, byte[] privateKey, byte[] encrypted) {
        if (ArrayUtils.isEmpty((byte[])privateKey) || ArrayUtils.isEmpty((byte[])encrypted)) {
            return null;
        }
        int c1Len = 65;
        int c3Len = 32;
        int c2Len = encrypted.length - (c1Len + c3Len);
        byte[] c1 = Arrays.copyOf(encrypted, c1Len);
        byte[] c2 = Arrays.copyOfRange(encrypted, c1Len, c1Len + c2Len);
        byte[] c3 = Arrays.copyOfRange(encrypted, c1Len + c2Len, encrypted.length);
        SM2 sm2 = new SM2(SM2.getPublicKey(ecParam, c1), SM2.getPrivateKey(privateKey), ecParam.n);
        sm2.decrypt(c2);
        if (!Arrays.equals(c3, sm2.doFinal())) {
            throw new SecurityException("Invalid SM3 digest.");
        }
        return c2;
    }

    public static byte[] sign(byte[] data, byte[] publicKey, byte[] privateKey) {
        return SM2.sign(data, null, publicKey, privateKey);
    }

    public static byte[] sign(byte[] data, byte[] ida, byte[] publicKey, byte[] privateKey) {
        return SM2.sign(ECParameters.SM2_BEST, data, ida, publicKey, privateKey);
    }

    public static byte[] sign(ECParameters ecParam, byte[] data, byte[] publicKey, byte[] privateKey) {
        return SM2.sign(ecParam, data, null, publicKey, privateKey);
    }

    public static byte[] sign(ECParameters ecParam, byte[] data, byte[] ida, byte[] publicKey, byte[] privateKey) {
        BigInteger k;
        ECPoint p;
        BigInteger r;
        ECPoint pubKey = SM2.getPublicKey(ecParam, publicKey);
        BigInteger priKey = SM2.getPrivateKey(privateKey);
        SM3Digest sm3 = SM3Digest.getInstance();
        sm3.update(SM2.calcZ(sm3, ecParam, ida, pubKey));
        sm3.update(data);
        BigInteger e = new BigInteger(1, sm3.doFinal());
        while ((r = e.add((p = ecParam.pointG.multiply(k = SecureRandoms.random(ecParam.n)).normalize()).getXCoord().toBigInteger()).mod(ecParam.n)).equals(BigInteger.ZERO) || r.add(k).equals(ecParam.n)) {
        }
        BigInteger n1 = priKey.add(BigInteger.ONE).modInverse(ecParam.n);
        BigInteger n2 = k.subtract(r.multiply(priKey));
        BigInteger n3 = n1.multiply(n2.mod(ecParam.n));
        BigInteger s = n3.mod(ecParam.n);
        return new Signature(r, s, ecParam.n).toByteArray();
    }

    public static boolean verify(byte[] data, byte[] signed, byte[] publicKey) {
        return SM2.verify(data, null, signed, publicKey);
    }

    public static boolean verify(byte[] data, byte[] ida, byte[] signed, byte[] publicKey) {
        return SM2.verify(ECParameters.SM2_BEST, data, ida, signed, publicKey);
    }

    public static boolean verify(ECParameters ecParam, byte[] data, byte[] signed, byte[] publicKey) {
        return SM2.verify(ecParam, data, null, signed, publicKey);
    }

    public static boolean verify(ECParameters ecParam, byte[] data, byte[] ida, byte[] signed, byte[] publicKey) {
        Signature signature = new Signature(signed, ecParam.n);
        if (SM2.isNotBetween(signature.r, BigInteger.ONE, ecParam.n) || SM2.isNotBetween(signature.s, BigInteger.ONE, ecParam.n)) {
            return false;
        }
        ECPoint pubKey = SM2.getPublicKey(ecParam, publicKey);
        SM3Digest sm3 = SM3Digest.getInstance();
        sm3.update(SM2.calcZ(sm3, ecParam, ida, pubKey));
        sm3.update(data);
        BigInteger e = new BigInteger(1, sm3.doFinal());
        BigInteger t = signature.r.add(signature.s).mod(ecParam.n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = ecParam.pointG.multiply(signature.s).normalize();
        ECPoint p2 = pubKey.multiply(t).normalize();
        BigInteger x1 = p1.add(p2).normalize().getXCoord().toBigInteger();
        BigInteger r = e.add(x1).mod(ecParam.n);
        return r.equals(signature.r);
    }

    public static boolean checkPublicKey(byte[] publicKey) {
        return SM2.checkPublicKey(SM2.getPublicKey(publicKey));
    }

    public static boolean checkPublicKey(ECParameters ecParam, byte[] publicKey) {
        return SM2.checkPublicKey(ecParam, SM2.getPublicKey(ecParam, publicKey));
    }

    public static boolean checkPublicKey(ECPoint publicKey) {
        return SM2.checkPublicKey(ECParameters.SM2_BEST, publicKey);
    }

    public static boolean checkPublicKey(ECParameters ecParam, ECPoint publicKey) {
        if (publicKey.isInfinity()) {
            return false;
        }
        BigInteger x = publicKey.getXCoord().toBigInteger();
        BigInteger y = publicKey.getYCoord().toBigInteger();
        if (SM2.isNotBetween(x, BigInteger.ZERO, ecParam.p) || SM2.isNotBetween(y, BigInteger.ZERO, ecParam.p)) {
            return false;
        }
        BigInteger x1 = x.pow(3).add(ecParam.a.multiply(x)).add(ecParam.b).mod(ecParam.p);
        BigInteger y1 = y.pow(2).mod(ecParam.p);
        return y1.equals(x1) && publicKey.multiply(ecParam.n).isInfinity();
    }

    static byte[] calcZ(SM3Digest sm3, ECParameters ecParam, ECPoint pubKey) {
        return SM2.calcZ(sm3, ecParam, null, pubKey);
    }

    static byte[] calcZ(SM3Digest sm3, ECParameters ecParam, byte[] ida, ECPoint pubKey) {
        sm3.reset();
        if (ida != null && ida.length > 0) {
            int idaBitLen = ida.length << 3;
            sm3.update((byte)(idaBitLen & 0xFF00));
            sm3.update((byte)(idaBitLen & 0xFF));
            sm3.update(ida);
        }
        sm3.update(ecParam.a.toByteArray());
        sm3.update(ecParam.b.toByteArray());
        sm3.update(ecParam.gx.toByteArray());
        sm3.update(ecParam.gy.toByteArray());
        sm3.update(pubKey.getXCoord().toBigInteger().toByteArray());
        sm3.update(pubKey.getYCoord().toBigInteger().toByteArray());
        return sm3.doFinal();
    }

    private static boolean isNotBetween(BigInteger number, BigInteger min, BigInteger max) {
        return number.compareTo(min) < 0 || number.compareTo(max) >= 0;
    }

    private static class Signature
    implements Serializable {
        private static final long serialVersionUID = -2732762291362285185L;
        final BigInteger r;
        final BigInteger s;
        final BigInteger n;

        Signature(BigInteger r, BigInteger s, BigInteger n) {
            this.r = r;
            this.s = s;
            this.n = n;
        }

        Signature(byte[] signed, BigInteger n) {
            this.n = n;
            int byteCount = (int)Math.ceil((double)this.n.bitLength() / 8.0);
            this.r = new BigInteger(1, Arrays.copyOfRange(signed, 0, byteCount));
            this.s = new BigInteger(1, Arrays.copyOfRange(signed, byteCount, byteCount << 1));
        }

        byte[] toByteArray() {
            int byteCount = (int)Math.ceil((double)this.n.bitLength() / 8.0);
            byte[] out = new byte[byteCount << 1];
            byte[] r1 = this.r.toByteArray();
            byte[] s1 = this.s.toByteArray();
            Bytes.tailCopy(r1, 0, r1.length, out, 0, byteCount);
            Bytes.tailCopy(s1, 0, s1.length, out, byteCount, byteCount);
            return out;
        }

        public String toString() {
            return Base64UrlSafe.encode(this.toByteArray());
        }
    }
}

