/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import org.apache.commons.lang3.StringUtils;

public class JacksonCurrencyUnit {
    public static final JacksonCurrencyUnit INSTANCE = new JacksonCurrencyUnit();
    private final JsonSerializer<CurrencyUnit> serializer = new Serializer();
    private final JsonDeserializer<CurrencyUnit> deserializer = new Deserializer();

    private JacksonCurrencyUnit() {
    }

    public JsonSerializer<CurrencyUnit> serializer() {
        return this.serializer;
    }

    public JsonDeserializer<CurrencyUnit> deserializer() {
        return this.deserializer;
    }

    private static class Deserializer
    extends JsonDeserializer<CurrencyUnit> {
        private Deserializer() {
        }

        public CurrencyUnit deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            String currencyCode = parser.getValueAsString();
            if (StringUtils.isBlank((CharSequence)currencyCode)) {
                return null;
            }
            return Monetary.getCurrency((String)currencyCode, (String[])new String[0]);
        }
    }

    private static class Serializer
    extends JsonSerializer<CurrencyUnit> {
        private Serializer() {
        }

        public void serialize(CurrencyUnit currencyUnit, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (currencyUnit == null) {
                generator.writeNull();
            } else {
                generator.writeString(currencyUnit.getCurrencyCode());
            }
        }
    }
}

