/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import org.javamoney.moneta.Money;

public class JacksonMoney {
    public static final JacksonMoney INSTANCE = new JacksonMoney();
    private static final String CURRENCY = "currency";
    private static final String NUMBER = "number";
    private final JsonSerializer<Money> serializer = new Serializer();
    private final JsonDeserializer<Money> deserializer = new Deserializer();

    private JacksonMoney() {
    }

    public JsonSerializer<Money> serializer() {
        return this.serializer;
    }

    public JsonDeserializer<Money> deserializer() {
        return this.deserializer;
    }

    private static class Deserializer
    extends JsonDeserializer<Money> {
        private Deserializer() {
        }

        public Money deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            BaseJsonNode jsonNode = (BaseJsonNode)parser.readValueAsTree();
            if (jsonNode == null || jsonNode instanceof NullNode) {
                return null;
            }
            String currency = jsonNode.required(JacksonMoney.CURRENCY).textValue();
            long number = jsonNode.required(JacksonMoney.NUMBER).longValue();
            return Money.ofMinor((CurrencyUnit)Monetary.getCurrency((String)currency, (String[])new String[0]), (long)number);
        }
    }

    private static class Serializer
    extends JsonSerializer<Money> {
        private Serializer() {
        }

        public void serialize(Money money, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (money == null) {
                generator.writeNull();
            } else {
                CurrencyUnit currency = money.getCurrency();
                generator.writeStartObject();
                generator.writeStringField(JacksonMoney.CURRENCY, currency.getCurrencyCode());
                generator.writeNumberField(JacksonMoney.NUMBER, money.getNumberStripped().movePointRight(currency.getDefaultFractionDigits()).longValueExact());
                generator.writeEndObject();
            }
        }
    }
}

