/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.json;

import cn.ponfee.commons.date.CustomLocalDateTimeDeserializer;
import cn.ponfee.commons.date.JavaUtilDateFormat;
import cn.ponfee.commons.date.LocalDateTimeFormat;
import cn.ponfee.commons.json.JacksonDate;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.util.Assert;

@ThreadSafe
public final class Jsons {
    public static final TypeReference<Map<String, Object>> MAP_NORMAL = new TypeReference<Map<String, Object>>(){};
    public static final Jsons NORMAL = new Jsons(JsonInclude.Include.NON_NULL);
    public static final Jsons ALL = new Jsons(null);
    private final ObjectMapper mapper;

    private Jsons(JsonInclude.Include include) {
        this.mapper = Jsons.createObjectMapper(include);
    }

    public void write(OutputStream output, Object target) {
        try {
            this.mapper.writeValue(output, target);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public String string(Object target) {
        try {
            return this.mapper.writeValueAsString(target);
        }
        catch (IOException e) {
            return (String)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public byte[] bytes(Object target) {
        try {
            return this.mapper.writeValueAsBytes(target);
        }
        catch (IOException e) {
            return (byte[])ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T parse(String json, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            return (T)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T parse(byte[] json, JavaType javaType) {
        if (json == null || json.length == 0) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            return (T)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T parse(String json, Class<T> target) {
        return this.parse(json, this.mapper.constructType(target));
    }

    public <T> T parse(byte[] json, Class<T> target) {
        return this.parse(json, this.mapper.constructType(target));
    }

    public <T> T parse(String json, Type type) {
        return this.parse(json, this.mapper.constructType(type));
    }

    public <T> T parse(byte[] json, Type type) {
        return this.parse(json, this.mapper.constructType(type));
    }

    public <T> T parse(String json, TypeReference<T> type) {
        return this.parse(json, this.mapper.constructType(type));
    }

    public <T> T parse(byte[] json, TypeReference<T> type) {
        return this.parse(json, this.mapper.constructType(type));
    }

    public static String toJson(Object target) {
        return NORMAL.string(target);
    }

    public static byte[] toBytes(Object target) {
        return NORMAL.bytes(target);
    }

    public static Object[] parseArray(String body, Class<?> ... types) {
        if (body == null) {
            return null;
        }
        ObjectMapper mapper = Jsons.NORMAL.mapper;
        JsonNode rootNode = Jsons.readTree(mapper, body);
        Assert.isTrue((boolean)rootNode.isArray(), (String)"Not array json data.");
        ArrayNode arrayNode = (ArrayNode)rootNode;
        if (types.length == 1 && arrayNode.size() > 1) {
            return new Object[]{Jsons.parse(mapper, (JsonNode)arrayNode, types[0])};
        }
        Object[] result = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = Jsons.parse(mapper, arrayNode.get(i), types[i]);
        }
        return result;
    }

    public static Object[] parseMethodArgs(String body, Method method) {
        if (body == null) {
            return null;
        }
        Type[] genericArgumentTypes = method.getGenericParameterTypes();
        int argumentCount = genericArgumentTypes.length;
        if (argumentCount == 0) {
            return null;
        }
        ObjectMapper mapper = Jsons.NORMAL.mapper;
        JsonNode rootNode = Jsons.readTree(mapper, body);
        if (rootNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)rootNode;
            if (argumentCount == 1 && arrayNode.size() > 1) {
                return new Object[]{Jsons.parse(mapper, (JsonNode)arrayNode, genericArgumentTypes[0])};
            }
            Assert.isTrue((argumentCount == arrayNode.size() ? 1 : 0) != 0, () -> "Method arguments size: " + argumentCount + ", but actual size: " + arrayNode.size());
            Object[] methodArguments = new Object[argumentCount];
            for (int i = 0; i < argumentCount; ++i) {
                methodArguments[i] = Jsons.parse(mapper, arrayNode.get(i), genericArgumentTypes[i]);
            }
            return methodArguments;
        }
        Assert.isTrue((argumentCount == 1 ? 1 : 0) != 0, (String)"Single object request parameter not support multiple arguments method.");
        return new Object[]{Jsons.parse(mapper, rootNode, genericArgumentTypes[0])};
    }

    public static <T> T fromJson(String json, JavaType javaType) {
        return NORMAL.parse(json, javaType);
    }

    public static <T> T fromJson(byte[] json, JavaType javaType) {
        return NORMAL.parse(json, javaType);
    }

    public static <T> T fromJson(String json, Class<T> target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(byte[] json, Class<T> target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(String json, Type target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(byte[] json, Type target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        return NORMAL.parse(json, type);
    }

    public static <T> T fromJson(byte[] json, TypeReference<T> type) {
        return NORMAL.parse(json, type);
    }

    public static ObjectMapper createObjectMapper(JsonInclude.Include include) {
        JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).build();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        if (include != null) {
            mapper.setSerializationInclusion(include);
        }
        Jsons.configObjectMapper(mapper);
        return mapper;
    }

    public static void configObjectMapper(ObjectMapper mapper) {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, false);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, false);
        mapper.configure(JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature(), true);
        mapper.setTimeZone(JavaUtilDateFormat.DEFAULT.getTimeZone());
        mapper.setDateFormat((DateFormat)JavaUtilDateFormat.DEFAULT);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, JacksonDate.INSTANCE.serializer());
        module.addDeserializer(Date.class, JacksonDate.INSTANCE.deserializer());
        mapper.registerModule((Module)module);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(LocalDateTimeFormat.PATTERN_11));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)CustomLocalDateTimeDeserializer.INSTANCE);
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormatter));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormatter));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormatter));
        mapper.registerModule((Module)javaTimeModule);
    }

    private static JsonNode readTree(ObjectMapper mapper, String body) {
        try {
            return mapper.readTree(body);
        }
        catch (JsonProcessingException e) {
            return (JsonNode)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static Object parse(ObjectMapper mapper, JsonNode jsonNode, Type type) {
        try {
            return mapper.readerFor(mapper.getTypeFactory().constructType(type)).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(mapper.treeAsTokens((TreeNode)jsonNode));
        }
        catch (IOException e) {
            return ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

