/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.limit.request;

import cn.ponfee.commons.jce.HmacAlgorithms;
import cn.ponfee.commons.jce.digest.HmacUtils;
import cn.ponfee.commons.limit.request.RequestLimitException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public abstract class RequestLimiter {
    private static final byte[] SALT_PREFIX = "{;a*9)p<?T".getBytes();
    public static final String CHECK_FREQ_KEY = "req:lmt:fre:";
    public static final String CHECK_THRE_KEY = "req:lmt:thr:";
    public static final String CACHE_CODE_KEY = "req:cah:code:";
    public static final String CHECK_CODE_KEY = "req:chk:code:";
    public static final String CACHE_CAPTCHA_KEY = "req:cah:cap:";
    public static final String TRACE_ACTION_KEY = "req:cnt:act:";

    public final RequestLimiter limitFrequency(String key, int period) throws RequestLimitException {
        return this.limitFrequency(key, period, "\u8bf7\u6c42\u9891\u7e41\uff0c\u8bf7" + RequestLimiter.format(period) + "\u540e\u518d\u8bd5\uff01");
    }

    public abstract RequestLimiter limitFrequency(String var1, int var2, String var3) throws RequestLimitException;

    public final RequestLimiter limitThreshold(String key, int period, int limit) throws RequestLimitException {
        return this.limitThreshold(key, period, limit, "\u8bf7\u6c42\u8d85\u9650\uff0c\u8bf7" + RequestLimiter.format(period) + "\u540e\u518d\u8bd5\uff01");
    }

    public abstract RequestLimiter limitThreshold(String var1, int var2, int var3, String var4) throws RequestLimitException;

    public abstract void cacheCode(String var1, String var2, int var3);

    public abstract RequestLimiter checkCode(String var1, String var2, int var3) throws RequestLimitException;

    public abstract void cacheCaptcha(String var1, String var2, int var3);

    public final boolean checkCaptcha(String key, String captcha) {
        return this.checkCaptcha(key, captcha, false);
    }

    public abstract boolean checkCaptcha(String var1, String var2, boolean var3);

    public abstract void recordAction(String var1, int var2);

    public abstract long countAction(String var1);

    public abstract void resetAction(String var1);

    public static String buildNonce(String code, String salt) {
        byte[] key = code.getBytes();
        Mac mac = HmacUtils.getInitializedMac(HmacAlgorithms.HmacMD5, key);
        mac.update(SALT_PREFIX);
        return Hex.encodeHexString((byte[])mac.doFinal(salt.getBytes()));
    }

    public static boolean verifyNonce(String nonce, String code, String salt) {
        return StringUtils.isNotEmpty((CharSequence)nonce) && nonce.equals(RequestLimiter.buildNonce(code, salt));
    }

    public static String format(int seconds) {
        int days = seconds / 86400;
        if (days > 365) {
            return days / 365 + (days % 365 / 30 + 10) / 12 + "\u5e74";
        }
        if (days > 30) {
            return days / 30 + (days % 30 + 25) / 30 + "\u4e2a\u6708";
        }
        int hours = (seconds %= 86400) / 3600;
        if (days > 0) {
            return days + (hours + 20) / 24 + "\u5929";
        }
        int minutes = (seconds %= 3600) / 60;
        if (hours > 0) {
            return hours + (minutes + 50) / 60 + "\u5c0f\u65f6";
        }
        seconds %= 60;
        if (minutes > 0) {
            return minutes + (seconds + 50) / 60 + "\u5206\u949f";
        }
        return seconds + "\u79d2";
    }

    static long expire(int ttl) {
        return System.currentTimeMillis() + (long)ttl * 1000L;
    }

    static class CacheValue<T>
    implements Serializable {
        private static final long serialVersionUID = 8615157453929878610L;
        final T value;
        final long expireTimeMillis;
        final AtomicInteger count;

        CacheValue(T value, long expireTimeMillis) {
            this.value = value;
            this.expireTimeMillis = expireTimeMillis;
            this.count = new AtomicInteger(1);
        }

        int increment() {
            return this.count.incrementAndGet();
        }

        int count() {
            return this.count.get();
        }

        T get() {
            return this.value;
        }

        boolean isExpire() {
            return this.expireTimeMillis < System.currentTimeMillis();
        }

        boolean isExpire(long timeMillis) {
            return this.expireTimeMillis < timeMillis;
        }
    }
}

