/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.model;

import cn.ponfee.commons.model.PageHandler;
import java.util.ArrayList;
import java.util.List;

public final class PageBoundsResolver {
    private PageBoundsResolver() {
    }

    public static List<PageBounds> resolve(int pageNum, int pageSize, long ... subTotalCounts) {
        long offset;
        if (subTotalCounts == null || subTotalCounts.length == 0) {
            return null;
        }
        long totalCounts = 0L;
        for (long subTotalCount : subTotalCounts) {
            totalCounts += subTotalCount;
        }
        if (totalCounts < 1L) {
            return null;
        }
        if (pageSize < 1) {
            ArrayList<PageBounds> bounds = new ArrayList<PageBounds>();
            for (int i = 0; i < subTotalCounts.length; ++i) {
                bounds.add(new PageBounds(i, subTotalCounts[i], 0L, (int)subTotalCounts[i]));
            }
            return bounds;
        }
        if (pageNum < 1) {
            pageNum = 1;
        }
        if ((offset = (long)PageHandler.computeOffset(pageNum, pageSize)) >= totalCounts) {
            pageNum = PageHandler.computeTotalPages(totalCounts, pageSize);
            offset = PageHandler.computeOffset(pageNum, pageSize);
        }
        ArrayList<PageBounds> bounds = new ArrayList<PageBounds>();
        long start = offset;
        long end = start + (long)pageSize;
        long cursor = 0L;
        for (int i = 0; i < subTotalCounts.length; ++i) {
            if (start < cursor + subTotalCounts[i]) {
                int limit;
                offset = start - cursor;
                if (end > cursor + subTotalCounts[i]) {
                    limit = (int)(cursor + subTotalCounts[i] - start);
                    bounds.add(new PageBounds(i, subTotalCounts[i], offset, limit));
                    start = cursor + subTotalCounts[i];
                } else {
                    limit = (int)(end - start);
                    bounds.add(new PageBounds(i, subTotalCounts[i], offset, limit));
                    break;
                }
            }
            cursor += subTotalCounts[i];
        }
        return bounds;
    }

    public static PageBounds resolve(int pageNum, int pageSize, long totalCounts) {
        List<PageBounds> list = PageBoundsResolver.resolve(pageNum, pageSize, new long[]{totalCounts});
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static final class PageBounds {
        private final int index;
        private final long total;
        private final long offset;
        private final int limit;

        PageBounds(int index, long total, long offset, int limit) {
            this.index = index;
            this.total = total;
            this.offset = offset;
            this.limit = limit;
        }

        public int getIndex() {
            return this.index;
        }

        public long getTotal() {
            return this.total;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.limit;
        }

        public String toString() {
            return "PageBounds [index=" + this.index + ", total=" + this.total + ", offset=" + this.offset + ", limit=" + this.limit + "]";
        }
    }
}

