/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.model;

import cn.ponfee.commons.http.HttpStatus;
import cn.ponfee.commons.model.CodeMsg;

public final class ResultCode
implements CodeMsg {
    private static final int SYS_CODE_MIN = 100;
    private static final int SYS_CODE_MAX = 599;
    private static final String SYS_ERROR = "Must in predefine reserved code [100, 599]";
    private static final String BIZ_ERROR = "Cannot defined in reserved code [100, 599]";
    public static final ResultCode OK = ResultCode.of0(200, "OK");
    public static final ResultCode CREATED = ResultCode.of0(201, "\u5df2\u521b\u5efa");
    public static final ResultCode ACCEPTED = ResultCode.of0(202, "\u5df2\u63a5\u53d7\uff0c\u7b49\u5f85\u5904\u7406");
    public static final ResultCode NOT_AUTHORITATIVE = ResultCode.of0(203, "\u975e\u6388\u6743\u4fe1\u606f");
    public static final ResultCode NO_CONTENT = ResultCode.of0(204, "\u5df2\u5904\u7406\uff0c\u65e0\u8fd4\u56de\u5185\u5bb9");
    public static final ResultCode REST_CONTENT = ResultCode.of0(205, "\u91cd\u7f6e\u5185\u5bb9");
    public static final ResultCode PARTIAL_CONTENT = ResultCode.of0(206, "\u90e8\u5206\u5185\u5bb9");
    public static final ResultCode REDIRECT = ResultCode.of0(300, "Multiple Choices");
    public static final ResultCode BAD_REQUEST = ResultCode.of0(400, "\u53c2\u6570\u9519\u8bef");
    public static final ResultCode UNAUTHORIZED = ResultCode.of0(401, "\u672a\u6388\u6743");
    public static final ResultCode FORBIDDEN = ResultCode.of0(403, "\u62d2\u7edd\u8bbf\u95ee");
    public static final ResultCode NOT_FOUND = ResultCode.of0(404, "\u8d44\u6e90\u672a\u627e\u5230");
    public static final ResultCode NOT_ALLOWED = ResultCode.of0(405, "\u65b9\u6cd5\u4e0d\u5141\u8bb8");
    public static final ResultCode NOT_ACCEPTABLE = ResultCode.of0(406, "\u8bf7\u6c42\u683c\u5f0f\u9519\u8bef");
    public static final ResultCode REQUEST_TIMEOUT = ResultCode.of0(408, "\u8bf7\u6c42\u8d85\u65f6");
    public static final ResultCode OPS_CONFLICT = ResultCode.of0(409, "\u6570\u636e\u4e0d\u5b58\u5728\u6216\u7248\u672c\u51b2\u7a81");
    public static final ResultCode UNSUPPORT_MEDIA = ResultCode.of0(415, "\u683c\u5f0f\u4e0d\u652f\u6301");
    public static final ResultCode SERVER_ERROR = ResultCode.of0(500, "\u670d\u52a1\u5668\u9519\u8bef");
    public static final ResultCode BAD_GATEWAY = ResultCode.of0(502, "\u7f51\u5173\u9519\u8bef");
    public static final ResultCode SERVER_UNAVAILABLE = ResultCode.of0(503, "\u670d\u52a1\u4e0d\u53ef\u7528");
    public static final ResultCode GATEWAY_TIMEOUT = ResultCode.of0(504, "\u7f51\u5173\u8d85\u65f6");
    public static final ResultCode SERVER_UNSUPPORTED = ResultCode.of0(505, "\u670d\u52a1\u4e0d\u652f\u6301");
    private final int code;
    private final boolean success;
    private final String msg;

    private ResultCode(int code, String msg) {
        this.code = code;
        this.success = HttpStatus.Series.valueOf(code) == HttpStatus.Series.SUCCESSFUL;
        this.msg = msg;
    }

    private static ResultCode of0(int code, String msg) {
        if (code < 100 || code > 599) {
            throw new IllegalArgumentException(SYS_ERROR);
        }
        return new ResultCode(code, msg);
    }

    public static ResultCode of(int code, String msg) {
        if (code >= 100 && code <= 599) {
            throw new IllegalArgumentException(BIZ_ERROR);
        }
        return new ResultCode(code, msg);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }
}

