/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.parser;

import cn.ponfee.commons.date.Dates;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class DateUDF {
    private static final Pattern PATTERN = Pattern.compile("[\\-+]?\\d+[YyMDdHhmWw]");

    public static String now(String format) {
        return DateUDF.format(DateUDF.now(), format);
    }

    public static String now(String format, String offset) {
        return DateUDF.format(DateUDF.compute(DateUDF.now(), offset), format);
    }

    public static String startDay(String format) {
        return DateUDF.format(Dates.startOfDay(DateUDF.now()), format);
    }

    public static String startDay(String format, String offset) {
        return DateUDF.format(Dates.startOfDay(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    public static String endDay(String format) {
        return DateUDF.format(Dates.endOfDay(DateUDF.now()), format);
    }

    public static String endDay(String format, String offset) {
        return DateUDF.format(Dates.endOfDay(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    public static String startWeek(String format) {
        return DateUDF.format(Dates.startOfWeek(DateUDF.now()), format);
    }

    public static String startWeek(String format, String offset) {
        return DateUDF.format(Dates.startOfWeek(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    public static String endWeek(String format) {
        return DateUDF.format(Dates.endOfWeek(DateUDF.now()), format);
    }

    public static String endWeek(String format, String offset) {
        return DateUDF.format(Dates.endOfWeek(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    public static String startMonth(String format) {
        return DateUDF.format(Dates.startOfMonth(DateUDF.now()), format);
    }

    public static String startMonth(String format, String offset) {
        return DateUDF.format(Dates.startOfMonth(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    public static String endMonth(String format) {
        return DateUDF.format(Dates.endOfMonth(DateUDF.now()), format);
    }

    public static String endMonth(String format, String offset) {
        return DateUDF.format(Dates.endOfMonth(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    public static String startYear(String format) {
        return DateUDF.format(Dates.startOfYear(DateUDF.now()), format);
    }

    public static String startYear(String format, String offset) {
        return DateUDF.format(Dates.startOfYear(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    public static String endYear(String format) {
        return DateUDF.format(Dates.endOfYear(DateUDF.now()), format);
    }

    public static String endYear(String format, String offset) {
        return DateUDF.format(Dates.endOfYear(DateUDF.compute(DateUDF.now(), offset)), format);
    }

    private static Date now() {
        return new Date();
    }

    private static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        if ("timestamp".equalsIgnoreCase(format)) {
            return String.valueOf(date.getTime());
        }
        return Dates.format(date, format);
    }

    private static Date compute(Date dateTime, String offset) {
        if (!PATTERN.matcher(offset).matches()) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        int amount = Integer.parseInt(StringUtils.substring((String)offset, (int)0, (int)-1));
        switch (offset.charAt(offset.length() - 1)) {
            case 'Y': 
            case 'y': {
                return Dates.plusYears(dateTime, amount);
            }
            case 'M': {
                return Dates.plusMonths(dateTime, amount);
            }
            case 'W': 
            case 'w': {
                return Dates.plusWeeks(dateTime, amount);
            }
            case 'D': 
            case 'd': {
                return Dates.plusDays(dateTime, amount);
            }
            case 'H': 
            case 'h': {
                return Dates.plusHours(dateTime, amount);
            }
            case 'm': {
                return Dates.plusMinutes(dateTime, amount);
            }
        }
        throw new IllegalArgumentException("Invalid offset: " + offset);
    }
}

