/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.pdf.sign;

import cn.ponfee.commons.util.ImageUtils;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class Signer {
    private final PrivateKey priKey;
    private final Certificate[] certChain;
    private final Image image;

    public Signer(PrivateKey priKey, Certificate[] certChain, byte[] img, boolean transparent) {
        this.priKey = priKey;
        this.certChain = certChain;
        if (transparent) {
            img = ImageUtils.transparent(new ByteArrayInputStream(img), 250, 235);
        }
        try {
            this.image = Image.getInstance((byte[])img);
        }
        catch (BadElementException | IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public PrivateKey getPriKey() {
        return this.priKey;
    }

    public Certificate[] getCertChain() {
        return this.certChain;
    }

    public Image getImage() {
        return this.image;
    }
}

