/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.reflect;

import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.reflect.Fields;
import cn.ponfee.commons.reflect.GenericUtils;
import cn.ponfee.commons.util.ObjectUtils;
import cn.ponfee.commons.util.SynchronizedCaches;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cglib.beans.BeanMap;

public enum BeanMaps {
    CGLIB{

        @Override
        public Map<String, Object> toMap(Object bean) {
            if (bean == null) {
                return null;
            }
            return BeanMap.create((Object)bean);
        }

        @Override
        public void copyFromMap(Map<String, Object> sourceMap, Object targetBean) {
            BeanMap.create((Object)targetBean).putAll(sourceMap);
        }
    }
    ,
    FIELDS{
        private final Map<Class<?>, List<Field>> cachedFields = new HashMap();

        @Override
        public Map<String, Object> toMap(Object bean) {
            if (bean == null) {
                return null;
            }
            List<Field> fields = this.getFields(bean.getClass());
            HashMap<String, Object> map = new HashMap<String, Object>(fields.size());
            fields.forEach(f -> map.put(f.getName(), Fields.get(bean, f)));
            return map;
        }

        @Override
        public void copyFromMap(Map<String, Object> sourceMap, Object targetBean) {
            Class<?> clazz = targetBean.getClass();
            for (Field field : this.getFields(clazz)) {
                String name = field.getName();
                if (!sourceMap.containsKey(name)) continue;
                Class type = GenericUtils.getFieldActualType(clazz, field);
                Fields.put(targetBean, field, ObjectUtils.cast(sourceMap.get(name), type));
            }
        }

        private List<Field> getFields(Class<?> beanType) {
            return SynchronizedCaches.get(beanType, this.cachedFields, type -> {
                List<Field> list = ClassUtils.listFields(type);
                return CollectionUtils.isEmpty(list) ? Collections.emptyList() : ImmutableList.copyOf(list);
            });
        }
    }
    ,
    PROPS{

        @Override
        public Map<String, Object> toMap(Object bean) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
                    String name = prop.getName();
                    if ("class".equals(name)) continue;
                    map.put(name, prop.getReadMethod().invoke(bean, new Object[0]));
                }
                return map;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void copyFromMap(Map<String, Object> sourceMap, Object targetBean) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(targetBean.getClass());
                for (PropertyDescriptor prop : beanInfo.getPropertyDescriptors()) {
                    String name = prop.getName();
                    if ("class".equals(name)) continue;
                    String name0 = name;
                    if (!sourceMap.containsKey(name) && !sourceMap.containsKey(name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name0)) && !sourceMap.containsKey(name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name0))) continue;
                    Object value = sourceMap.get(name);
                    Class<?> type = prop.getPropertyType();
                    if (type.isPrimitive() && ObjectUtils.isEmpty(value)) continue;
                    prop.getWriteMethod().invoke(targetBean, ObjectUtils.cast(value, type));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    };


    public abstract Map<String, Object> toMap(Object var1);

    public abstract void copyFromMap(Map<String, Object> var1, Object var2);

    public final <T> T toBean(Map<String, Object> map, Class<T> beanType) {
        T bean = ObjectUtils.newInstance(beanType);
        this.copyFromMap(map, bean);
        return bean;
    }

    public final void copyFromBean(Object sourceBean, Map<String, Object> targetMap) {
        targetMap.putAll(this.toMap(sourceBean));
    }
}

