/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.reflect;

import cn.ponfee.commons.base.Predicates;
import cn.ponfee.commons.base.tuple.Tuple2;
import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.reflect.GenericUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

public final class Fields {
    private static final Unsafe UNSAFE;
    private static final long BASE_OFFSET;
    private static final int INDEX_SCALE;
    private static final int ADDRESS_SIZE;

    public static long addressOf(Object obj) {
        return Fields.addressOf(new Object[]{obj}, 0);
    }

    public static long addressOf(Object[] array, int index) {
        switch (INDEX_SCALE) {
            case 4: {
                return ((long)UNSAFE.getInt(array, BASE_OFFSET + (long)index * (long)INDEX_SCALE) & 0xFFFFFFFFL) * (long)ADDRESS_SIZE;
            }
            case 8: {
                return UNSAFE.getLong(array, BASE_OFFSET + (long)index * (long)INDEX_SCALE) * (long)ADDRESS_SIZE;
            }
        }
        throw new Error("Unsupported address size: " + INDEX_SCALE);
    }

    public static void put(Object target, String name, Object value) {
        try {
            Tuple2<?, Field> tuple = Fields.getField(target, name);
            Fields.put(tuple.a, (Field)tuple.b, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void putIfNull(Object target, String name, Object value) {
        try {
            Tuple2<?, Field> tuple = Fields.getField(target, name);
            Fields.putIfNull(tuple.a, (Field)tuple.b, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void putIfNull(Object target, Field field, Object value) {
        if (Fields.get(target, field) == null) {
            Fields.put(target, field, value);
        }
    }

    public static void put(Object target, Field field, Object value) {
        long fieldOffset = Fields.getFieldOffset(field);
        Class type = GenericUtils.getFieldActualType(target.getClass(), field);
        if (Boolean.TYPE.equals(type)) {
            UNSAFE.putBoolean(target, fieldOffset, (Boolean)value);
        } else if (Byte.TYPE.equals(type)) {
            UNSAFE.putByte(target, fieldOffset, (Byte)value);
        } else if (Character.TYPE.equals(type)) {
            UNSAFE.putChar(target, fieldOffset, ((Character)value).charValue());
        } else if (Short.TYPE.equals(type)) {
            UNSAFE.putShort(target, fieldOffset, (Short)value);
        } else if (Integer.TYPE.equals(type)) {
            UNSAFE.putInt(target, fieldOffset, (Integer)value);
        } else if (Long.TYPE.equals(type)) {
            UNSAFE.putLong(target, fieldOffset, (Long)value);
        } else if (Double.TYPE.equals(type)) {
            UNSAFE.putDouble(target, fieldOffset, (Double)value);
        } else if (Float.TYPE.equals(type)) {
            UNSAFE.putFloat(target, fieldOffset, ((Float)value).floatValue());
        } else {
            UNSAFE.putObject(target, fieldOffset, value);
        }
    }

    public static Object get(Object target, String name) {
        try {
            Tuple2<?, Field> tuple = Fields.getField(target, name);
            return Fields.get(tuple.a, (Field)tuple.b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object get(Object target, Field field) {
        long fieldOffset = Fields.getFieldOffset(field);
        Class type = GenericUtils.getFieldActualType(target.getClass(), field);
        if (Boolean.TYPE.equals(type)) {
            return UNSAFE.getBoolean(target, fieldOffset);
        }
        if (Byte.TYPE.equals(type)) {
            return UNSAFE.getByte(target, fieldOffset);
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf(UNSAFE.getChar(target, fieldOffset));
        }
        if (Short.TYPE.equals(type)) {
            return UNSAFE.getShort(target, fieldOffset);
        }
        if (Integer.TYPE.equals(type)) {
            return UNSAFE.getInt(target, fieldOffset);
        }
        if (Long.TYPE.equals(type)) {
            return UNSAFE.getLong(target, fieldOffset);
        }
        if (Double.TYPE.equals(type)) {
            return UNSAFE.getDouble(target, fieldOffset);
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(UNSAFE.getFloat(target, fieldOffset));
        }
        return UNSAFE.getObject(target, fieldOffset);
    }

    public static void putVolatile(Object target, Field field, Object value) {
        long fieldOffset = Fields.getFieldOffset(field);
        Class type = GenericUtils.getFieldActualType(target.getClass(), field);
        if (Boolean.TYPE.equals(type)) {
            UNSAFE.putBooleanVolatile(target, fieldOffset, (Boolean)value);
        } else if (Byte.TYPE.equals(type)) {
            UNSAFE.putByteVolatile(target, fieldOffset, (Byte)value);
        } else if (Character.TYPE.equals(type)) {
            UNSAFE.putCharVolatile(target, fieldOffset, ((Character)value).charValue());
        } else if (Short.TYPE.equals(type)) {
            UNSAFE.putShortVolatile(target, fieldOffset, (Short)value);
        } else if (Integer.TYPE.equals(type)) {
            UNSAFE.putIntVolatile(target, fieldOffset, (Integer)value);
        } else if (Long.TYPE.equals(type)) {
            UNSAFE.putLongVolatile(target, fieldOffset, (Long)value);
        } else if (Double.TYPE.equals(type)) {
            UNSAFE.putDoubleVolatile(target, fieldOffset, (Double)value);
        } else if (Float.TYPE.equals(type)) {
            UNSAFE.putFloatVolatile(target, fieldOffset, ((Float)value).floatValue());
        } else {
            UNSAFE.putObjectVolatile(target, fieldOffset, value);
        }
    }

    public static Object getVolatile(Object target, String name) {
        try {
            Tuple2<?, Field> tuple = Fields.getField(target, name);
            return Fields.getVolatile(tuple.a, (Field)tuple.b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getVolatile(Object target, Field field) {
        long fieldOffset = Fields.getFieldOffset(field);
        Class type = GenericUtils.getFieldActualType(target.getClass(), field);
        if (Boolean.TYPE.equals(type)) {
            return UNSAFE.getBooleanVolatile(target, fieldOffset);
        }
        if (Byte.TYPE.equals(type)) {
            return UNSAFE.getByteVolatile(target, fieldOffset);
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf(UNSAFE.getCharVolatile(target, fieldOffset));
        }
        if (Short.TYPE.equals(type)) {
            return UNSAFE.getShortVolatile(target, fieldOffset);
        }
        if (Integer.TYPE.equals(type)) {
            return UNSAFE.getIntVolatile(target, fieldOffset);
        }
        if (Long.TYPE.equals(type)) {
            return UNSAFE.getLongVolatile(target, fieldOffset);
        }
        if (Double.TYPE.equals(type)) {
            return UNSAFE.getDoubleVolatile(target, fieldOffset);
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(UNSAFE.getFloatVolatile(target, fieldOffset));
        }
        return UNSAFE.getObjectVolatile(target, fieldOffset);
    }

    private static Tuple2<?, Field> getField(Object obj, String name) {
        Tuple2<Class<?>, Predicates> tuple = ClassUtils.obtainClass(obj);
        if (((Predicates)((Object)tuple.b)).state()) {
            return ClassUtils.getStaticFieldInClassChain((Class)tuple.a, name);
        }
        return Tuple2.of(obj, ClassUtils.getField((Class)tuple.a, name));
    }

    private static long getFieldOffset(Field field) {
        return Modifier.isStatic(field.getModifiers()) ? UNSAFE.staticFieldOffset(field) : UNSAFE.objectFieldOffset(field);
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
            f.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("failed to get unsafe instance", e);
        }
        BASE_OFFSET = UNSAFE.arrayBaseOffset(Object[].class);
        INDEX_SCALE = UNSAFE.arrayIndexScale(Object[].class);
        ADDRESS_SIZE = UNSAFE.addressSize();
    }
}

