/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.resource;

import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.resource.ClassPathResourceLoader;
import cn.ponfee.commons.resource.FileSystemResourceLoader;
import cn.ponfee.commons.resource.Resource;
import cn.ponfee.commons.resource.WebappResourceLoader;
import cn.ponfee.commons.util.Strings;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class ResourceLoaderFacade {
    private static final String WEB_PREFIX = "webapp:";
    static final String FS_PREFIX = "file:";
    private static final Pattern PATTERN = Pattern.compile("^(\\s*(?i)(classpath|webapp|file):\\s*)?(.+)$");
    private static final ClassPathResourceLoader CP_LOADER = new ClassPathResourceLoader();
    private static final FileSystemResourceLoader FS_LOADER = new FileSystemResourceLoader();
    private static final WebappResourceLoader WEB_LOADER = new WebappResourceLoader();

    public static void setServletContext(@Nonnull ServletContext servletContext) {
        if (servletContext != null) {
            WEB_LOADER.setServletContext(servletContext);
        }
    }

    public static Resource getResource(String filePath, Class<?> contextClass) {
        return ResourceLoaderFacade.getResource(filePath, contextClass, null);
    }

    public static Resource getResource(String filePath, String encoding) {
        return ResourceLoaderFacade.getResource(filePath, null, encoding);
    }

    public static Resource getResource(String filePath) {
        return ResourceLoaderFacade.getResource(filePath, null, null);
    }

    public static Resource getResource(String filePath, Class<?> contextClass, String encoding) {
        Matcher matcher = PATTERN.matcher(filePath);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid file path: " + filePath);
        }
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = "UTF-8";
        }
        filePath = Strings.cleanPath(matcher.group(3).trim());
        switch (((String)ObjectUtils.defaultIfNull((Object)matcher.group(1), (Object)"")).toLowerCase()) {
            case "file:": {
                return FS_LOADER.getResource(filePath, encoding);
            }
            case "webapp:": {
                return WEB_LOADER.getResource(ResourceLoaderFacade.resolveWebapp(filePath), encoding);
            }
        }
        filePath = ResourceLoaderFacade.resolveClasspath(filePath, contextClass);
        return CP_LOADER.getResource(filePath, contextClass, encoding);
    }

    public static List<Resource> listResources(String[] extensions, Class<?> contextClass) {
        return ResourceLoaderFacade.listResources("", extensions, false, contextClass, "UTF-8");
    }

    public static List<Resource> listResources(String dir, String[] extensions, boolean recursive) {
        return ResourceLoaderFacade.listResources(dir, extensions, recursive, null, "UTF-8");
    }

    public static List<Resource> listResources(String dir, String[] extensions, boolean recursive, String encoding) {
        return ResourceLoaderFacade.listResources(dir, extensions, recursive, null, encoding);
    }

    public static List<Resource> listResources(String dir, String[] extensions, boolean recursive, Class<?> contextClass, String encoding) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)dir)) {
            dir = ".";
        }
        if (!(matcher = PATTERN.matcher(dir)).matches()) {
            throw new IllegalArgumentException("Invalid directory: " + dir);
        }
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = "UTF-8";
        }
        dir = Strings.cleanPath(matcher.group(3).trim());
        switch (((String)ObjectUtils.defaultIfNull((Object)matcher.group(1), (Object)"")).toLowerCase()) {
            case "file:": {
                return FS_LOADER.listResources(dir, extensions, recursive);
            }
            case "webapp:": {
                return WEB_LOADER.listResources(ResourceLoaderFacade.resolveWebapp(dir), extensions, recursive, encoding);
            }
        }
        dir = ResourceLoaderFacade.resolveClasspath(dir, contextClass);
        return CP_LOADER.listResources(dir, extensions, recursive, contextClass, encoding);
    }

    private static String resolveWebapp(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static String resolveClasspath(String path, Class<?> contextClass) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        } else if (contextClass != null) {
            path = ClassUtils.getPackagePath(contextClass) + "/" + path;
        }
        return path;
    }
}

