/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.schema;

import cn.ponfee.commons.exception.ServerException;
import cn.ponfee.commons.json.Jsons;
import cn.ponfee.commons.schema.DataColumn;
import cn.ponfee.commons.schema.DataStructure;
import cn.ponfee.commons.schema.NormalStructure;
import cn.ponfee.commons.schema.PlainStructure;
import cn.ponfee.commons.schema.TableStructure;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum DataStructures {
    NORMAL(NormalStructure.class){

        @Override
        public NormalStructure empty() {
            return new NormalStructure(0);
        }
    }
    ,
    TABLE(TableStructure.class){
        private final DataColumn[] empty = new DataColumn[0];

        @Override
        public DataStructure empty() {
            return new TableStructure(this.empty, Collections.emptyList());
        }

        @Override
        public DataStructure parse(String text) {
            TableStructure table = (TableStructure)Jsons.fromJson(text, this.type());
            if (table.getColumns() == null && table.getDataset() == null) {
                throw new IllegalArgumentException("Invalid table structure: " + text);
            }
            return table;
        }
    }
    ,
    PLAIN(PlainStructure.class){
        private final PlainStructure empty = new PlainStructure("");

        @Override
        public DataStructure empty() {
            return this.empty;
        }
    };

    private static final DataStructures DEFAULT_STRUCTURE;
    private final Class<? extends DataStructure> type;

    private DataStructures(Class<? extends DataStructure> type) {
        this.type = type;
    }

    public DataStructure parse(String text) {
        return Jsons.fromJson(text, this.type());
    }

    public abstract DataStructure empty();

    public Class<? extends DataStructure> type() {
        return this.type;
    }

    public static DataStructures ofType(Class<? extends DataStructure> type) {
        if (type == null) {
            return DEFAULT_STRUCTURE;
        }
        for (DataStructures ds : DataStructures.values()) {
            if (ds.type != type) continue;
            return ds;
        }
        throw new UnsupportedOperationException("Unknown structure type: " + type);
    }

    public static DataStructures ofName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return DEFAULT_STRUCTURE;
        }
        for (DataStructures ds : DataStructures.values()) {
            if (!ds.name().equalsIgnoreCase(name)) continue;
            return ds;
        }
        throw new UnsupportedOperationException("Unknown structure type: " + name);
    }

    public static DataStructure empty(String name) {
        return DataStructures.ofName(name).empty();
    }

    public static DataStructure detect(String text, boolean strict) throws ParseException {
        for (DataStructures ds : DataStructures.values()) {
            try {
                return ds.parse(text);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        if (!strict) {
            return new PlainStructure(text);
        }
        throw new ParseException("Unresolvable text data: " + text, 0);
    }

    public static <S extends DataStructure, T extends DataStructure> T convert(S source, Class<T> targetType) {
        return DataStructures.convert(source, DataStructures.ofType(targetType).name());
    }

    public static <S extends DataStructure, T extends DataStructure> T convert(S source, DataStructures targetType) {
        return DataStructures.convert(source, (targetType == null ? DEFAULT_STRUCTURE : targetType).name());
    }

    public static <S extends DataStructure, T extends DataStructure> T convert(S source, String structure) {
        Method method;
        if (source == null) {
            return null;
        }
        DataStructures sourceType = DataStructures.ofType(source.getClass());
        String structure0 = Optional.ofNullable(structure).filter(StringUtils::isNotBlank).map(String::toUpperCase).orElse(DEFAULT_STRUCTURE.name());
        if (structure0.equals(sourceType.name())) {
            return (T)source;
        }
        String methodName = "to" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, structure0);
        try {
            method = source.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unknown structure type: " + structure, e);
        }
        try {
            return (T)((DataStructure)method.invoke(source, new Object[0]));
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)structure)) {
                return (T)source.toPlain();
            }
            throw new ServerException("Structure type convert failed, expect: " + structure + ", actual: " + sourceType.name(), (Throwable)e);
        }
    }

    static {
        DEFAULT_STRUCTURE = NORMAL;
    }
}

