/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.schema;

import cn.ponfee.commons.json.Jsons;
import cn.ponfee.commons.schema.DataColumn;
import cn.ponfee.commons.schema.DataStructure;
import cn.ponfee.commons.schema.DataType;
import cn.ponfee.commons.schema.PlainStructure;
import cn.ponfee.commons.schema.TableStructure;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class NormalStructure
extends ArrayList<LinkedHashMap<String, Object>>
implements DataStructure {
    private static final long serialVersionUID = 9067243551591375987L;

    public NormalStructure() {
    }

    public NormalStructure(int minCapacity) {
        super(minCapacity);
    }

    @Override
    public NormalStructure toNormal() {
        return this;
    }

    @Override
    public TableStructure toTable() {
        ArrayList<Object[]> dataset = new ArrayList<Object[]>(this.size());
        int r = 0;
        int c = 0;
        LinkedHashMap map = (LinkedHashMap)this.get(r++);
        DataColumn[] columns = new DataColumn[map.size()];
        Object[] row = new Object[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            DataType type = DataType.detect(Objects.toString(entry.getValue(), null));
            columns[c] = new DataColumn((String)entry.getKey(), type, null);
            row[c] = columns[c].getType().convert(entry.getValue());
            ++c;
        }
        dataset.add(row);
        int n = this.size();
        while (r < n) {
            map = (LinkedHashMap)this.get(r);
            row = new Object[map.size()];
            for (c = 0; c < columns.length; ++c) {
                row[c] = map.get(columns[c].getName());
            }
            dataset.add(row);
            ++r;
        }
        return new TableStructure(columns, dataset);
    }

    @Override
    public PlainStructure toPlain() {
        return new PlainStructure(Jsons.toJson(this));
    }
}

