/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.schema;

import cn.ponfee.commons.json.Jsons;
import cn.ponfee.commons.schema.DataColumn;
import cn.ponfee.commons.schema.DataStructure;
import cn.ponfee.commons.schema.DataTable;
import cn.ponfee.commons.schema.NormalStructure;
import cn.ponfee.commons.schema.PlainStructure;
import java.util.LinkedHashMap;
import java.util.List;

public final class TableStructure
implements DataStructure {
    private static final long serialVersionUID = 1L;
    private DataColumn[] columns;
    private List<Object[]> dataset;

    public TableStructure() {
    }

    public TableStructure(DataColumn[] columns, List<Object[]> dataset) {
        this.columns = columns;
        this.dataset = dataset;
    }

    @Override
    public NormalStructure toNormal() {
        NormalStructure list = new NormalStructure();
        for (Object[] row : this.dataset) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(row.length);
            for (int i = 0; i < row.length; ++i) {
                map.put(this.columns[i].getName(), row[i]);
            }
            list.add(map);
        }
        return list;
    }

    @Override
    public TableStructure toTable() {
        return this;
    }

    @Override
    public PlainStructure toPlain() {
        return new PlainStructure(Jsons.toJson(this));
    }

    public static TableStructure of(DataTable table) {
        return new TableStructure(table.getColumns(), table.getDataset());
    }

    public DataColumn[] getColumns() {
        return this.columns;
    }

    public void setColumns(DataColumn[] columns) {
        this.columns = columns;
    }

    public List<Object[]> getDataset() {
        return this.dataset;
    }

    public void setDataset(List<Object[]> dataset) {
        this.dataset = dataset;
    }
}

