/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.serial;

import cn.ponfee.commons.collect.ByteArrayTrait;
import cn.ponfee.commons.io.GzipProcessor;
import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.serial.SerializationException;
import cn.ponfee.commons.serial.Serializer;

public class ByteArrayTraitSerializer
extends Serializer {
    protected byte[] serialize0(Object obj, boolean compress) {
        if (!(obj instanceof ByteArrayTrait)) {
            throw new SerializationException("object must be ByteArrayTrait type, but it's " + ClassUtils.getClassName(obj.getClass()) + " type");
        }
        return this.serialize((ByteArrayTrait)obj, compress);
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> clazz, boolean compress) {
        if (!ByteArrayTrait.class.isAssignableFrom(clazz)) {
            throw new SerializationException("clazz must be ByteArrayTrait.class, but it's " + ClassUtils.getClassName(clazz) + ".class");
        }
        if (compress) {
            bytes = GzipProcessor.decompress(bytes);
        }
        return ByteArrayTraitSerializer.ofBytes(bytes, clazz);
    }

    public static <T extends ByteArrayTrait> T ofBytes(byte[] bytes, Class<T> type) {
        return (T)((ByteArrayTrait)ClassUtils.newInstance(type, new Class[]{byte[].class}, new Object[]{bytes}));
    }

    public byte[] serialize(ByteArrayTrait trait, boolean compress) {
        if (trait == null) {
            return null;
        }
        byte[] bytes = trait.toByteArray();
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }
}

