/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.serial;

import cn.ponfee.commons.collect.ByteArrayTrait;
import cn.ponfee.commons.collect.ByteArrayWrapper;
import cn.ponfee.commons.io.GzipProcessor;
import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.serial.ByteArrayTraitSerializer;
import cn.ponfee.commons.serial.KryoSerializer;
import cn.ponfee.commons.serial.Serializer;
import cn.ponfee.commons.serial.ToStringSerializer;
import cn.ponfee.commons.util.Bytes;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;

public class WrappedSerializer
extends Serializer {
    public static final WrappedSerializer WRAPPED_KRYO_SERIALIZER = new WrappedSerializer(KryoSerializer.INSTANCE);
    public static final WrappedSerializer WRAPPED_TOSTRING_SERIALIZER = new WrappedSerializer(new ToStringSerializer());
    public static final byte BOOL_TRUE_BYTE = -1;
    public static final byte BOOL_FALSE_BYTE = 0;
    private static final Map<Class<?>, Object> PRIMITIVES = new ImmutableMap.Builder().put(Boolean.TYPE, (Object)Boolean.FALSE).put(Byte.TYPE, (Object)0).put(Short.TYPE, (Object)0).put(Character.TYPE, (Object)Character.valueOf('\u0000')).put(Integer.TYPE, (Object)0).put(Long.TYPE, (Object)0L).put(Float.TYPE, (Object)Float.valueOf(0.0f)).put(Double.TYPE, (Object)0.0).build();
    private final Serializer wrapper;

    public WrappedSerializer(Serializer wrapped) {
        this.wrapper = wrapped;
    }

    protected byte[] serialize0(Object obj, boolean compress) {
        byte[] bytes = this.serialize0(obj);
        return compress ? GzipProcessor.compress(bytes) : bytes;
    }

    @Override
    protected <T> T deserialize0(byte[] bytes, Class<T> type, boolean compress) {
        if (compress) {
            bytes = GzipProcessor.decompress(bytes);
        }
        return this.deserialize0(bytes, type);
    }

    public byte[] serialize(boolean value) {
        return new byte[]{value ? (byte)-1 : 0};
    }

    public byte[] serialize(byte value) {
        return new byte[]{value};
    }

    public byte[] serialize(short value) {
        return Bytes.toBytes(value);
    }

    public byte[] serialize(char value) {
        return Bytes.toBytes(value);
    }

    public byte[] serialize(int value) {
        return Bytes.toBytes(value);
    }

    public byte[] serialize(long value) {
        return Bytes.toBytes(value);
    }

    public byte[] serialize(float value) {
        return Bytes.toBytes(value);
    }

    public byte[] serialize(double value) {
        return Bytes.toBytes(value);
    }

    public byte[] serialize(Boolean value) {
        return value == null ? null : this.serialize((boolean)value);
    }

    public byte[] serialize(Byte value) {
        return value == null ? null : this.serialize((byte)value);
    }

    public byte[] serialize(Short value) {
        return value == null ? null : this.serialize((short)value);
    }

    public byte[] serialize(Character value) {
        return value == null ? null : this.serialize(value.charValue());
    }

    public byte[] serialize(Integer value) {
        return value == null ? null : this.serialize((int)value);
    }

    public byte[] serialize(Long value) {
        return value == null ? null : this.serialize((long)value);
    }

    public byte[] serialize(Float value) {
        return value == null ? null : this.serialize(value.floatValue());
    }

    public byte[] serialize(Double value) {
        return value == null ? null : this.serialize((double)value);
    }

    public byte[] serialize(byte[] value) {
        return value;
    }

    public byte[] serialize(Byte[] value) {
        return value == null ? null : ArrayUtils.toPrimitive((Byte[])value);
    }

    public byte[] serialize(Date value) {
        return value == null ? null : Bytes.toBytes(value.getTime());
    }

    public byte[] serialize(ByteArrayWrapper value) {
        return value == null ? null : value.getArray();
    }

    public byte[] serialize(ByteArrayTrait value) {
        return value == null ? null : value.toByteArray();
    }

    public byte[] serialize(CharSequence value) {
        return value == null ? null : Serializers.STRING.toBytes(value.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(InputStream value) {
        if (value == null) {
            return null;
        }
        try (InputStream input = value;){
            byte[] byArray = IOUtils.toByteArray((InputStream)input);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] serialize(ByteBuffer value) {
        return value == null ? null : value.array();
    }

    public byte[] serialize(Enum<?> value) {
        return value == null ? null : Serializers.STRING.toBytes(value.name());
    }

    private byte[] serialize0(Object value) {
        if (value == null) {
            return null;
        }
        Serializers serializer = Serializers.of(value.getClass());
        if (serializer != null) {
            return serializer.toBytes(value);
        }
        if (value instanceof CharSequence) {
            return Serializers.STRING.toBytes(value.toString());
        }
        if (value instanceof InputStream) {
            return this.serialize((InputStream)value);
        }
        if (value instanceof ByteArrayTrait) {
            return ((ByteArrayTrait)value).toByteArray();
        }
        if (value instanceof ByteBuffer) {
            return ((ByteBuffer)value).array();
        }
        if (value instanceof Enum) {
            return this.serialize((Enum)value);
        }
        return this.wrapper.serialize(value);
    }

    private <T> T deserialize0(byte[] value, Class<T> type) {
        if (ArrayUtils.isEmpty((byte[])value) && type.isPrimitive()) {
            return (T)PRIMITIVES.get(type);
        }
        if (value == null) {
            return null;
        }
        Serializers serializer = Serializers.of(type);
        if (serializer != null) {
            return serializer.fromBytes(value);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return ClassUtils.newInstance(type, new Class[]{String.class}, new Object[]{Serializers.STRING.fromBytes(value)});
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return (T)new ByteArrayInputStream(value);
        }
        if (ByteArrayTrait.class.isAssignableFrom(type)) {
            return ByteArrayTraitSerializer.ofBytes(value, type);
        }
        if (ByteBuffer.class.isAssignableFrom(type)) {
            return (T)ByteBuffer.wrap(value);
        }
        if (type.isEnum()) {
            return (T)EnumUtils.getEnumIgnoreCase(type, (String)((String)Serializers.STRING.fromBytes(value)));
        }
        return this.wrapper.deserialize(value, type);
    }

    private static class Hide {
        private static final Map<Class<?>, Serializers> MAPPING = new HashMap();

        private Hide() {
        }
    }

    private static enum Serializers {
        BOOLEAN(new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            byte[] to(Object value) {
                return new byte[]{(Boolean)value != false ? (byte)-1 : 0};
            }

            Boolean from(byte[] value) {
                return value[0] != 0;
            }
        }
        ,
        BYTE(new Class[]{Byte.TYPE, Byte.class}){

            @Override
            byte[] to(Object value) {
                return new byte[]{(Byte)value};
            }

            Byte from(byte[] value) {
                return value[0];
            }
        }
        ,
        SHORT(new Class[]{Short.TYPE, Short.class}){

            @Override
            byte[] to(Object value) {
                return Bytes.toBytes((Short)value);
            }

            Short from(byte[] value) {
                return Bytes.toShort(value);
            }
        }
        ,
        CHAR(new Class[]{Character.TYPE, Character.class}){

            @Override
            byte[] to(Object value) {
                return Bytes.toBytes(((Character)value).charValue());
            }

            Character from(byte[] value) {
                return Character.valueOf(Bytes.toChar(value));
            }
        }
        ,
        INT(new Class[]{Integer.TYPE, Integer.class}){

            @Override
            byte[] to(Object value) {
                return Bytes.toBytes((Integer)value);
            }

            Integer from(byte[] value) {
                return Bytes.toInt(value);
            }
        }
        ,
        LONG(new Class[]{Long.TYPE, Long.class}){

            @Override
            byte[] to(Object value) {
                return Bytes.toBytes((Long)value);
            }

            Long from(byte[] value) {
                return Bytes.toLong(value);
            }
        }
        ,
        FLOAT(new Class[]{Float.TYPE, Float.class}){

            @Override
            byte[] to(Object value) {
                return Bytes.toBytes(((Float)value).floatValue());
            }

            Float from(byte[] value) {
                return Float.valueOf(Bytes.toFloat(value));
            }
        }
        ,
        DOUBLE(new Class[]{Double.TYPE, Double.class}){

            @Override
            byte[] to(Object value) {
                return Bytes.toBytes((Double)value);
            }

            Double from(byte[] value) {
                return Bytes.toDouble(value);
            }
        }
        ,
        PRIMITIVE_BYTES(new Class[]{byte[].class}){

            @Override
            byte[] to(Object value) {
                return (byte[])value;
            }

            byte[] from(byte[] value) {
                return value;
            }
        }
        ,
        WRAP_BYTES(new Class[]{Byte[].class}){

            @Override
            byte[] to(Object value) {
                return ArrayUtils.toPrimitive((Byte[])((Byte[])value));
            }

            Byte[] from(byte[] value) {
                return ArrayUtils.toObject((byte[])value);
            }
        }
        ,
        STRING(new Class[]{String.class}){

            @Override
            byte[] to(Object value) {
                return ((String)value).getBytes(StandardCharsets.UTF_8);
            }

            String from(byte[] value) {
                return new String(value, StandardCharsets.UTF_8);
            }
        }
        ,
        DATE(new Class[]{Date.class}){

            @Override
            byte[] to(Object value) {
                return Bytes.toBytes(((Date)value).getTime());
            }

            Date from(byte[] value) {
                return new Date(Bytes.toLong(value));
            }
        }
        ,
        BYTE_ARRAY_WRAP(new Class[]{ByteArrayWrapper.class}){

            @Override
            byte[] to(Object value) {
                return ((ByteArrayWrapper)value).getArray();
            }

            ByteArrayWrapper from(byte[] value) {
                return ByteArrayWrapper.of(value);
            }
        };


        private Serializers(Class<?> ... types) {
            for (Class<?> type : types) {
                Hide.MAPPING.put(type, this);
            }
        }

        final byte[] toBytes(Object value) {
            return value == null ? null : this.to(value);
        }

        final <T> T fromBytes(byte[] value) {
            return value == null ? null : (T)this.from(value);
        }

        abstract byte[] to(Object var1);

        abstract <T> T from(byte[] var1);

        static Serializers of(Class<?> targetType) {
            return (Serializers)((Object)Hide.MAPPING.get(targetType));
        }
    }
}

