/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.spring;

import cn.ponfee.commons.model.TypedMap;
import cn.ponfee.commons.reflect.ClassUtils;
import cn.ponfee.commons.reflect.Fields;
import cn.ponfee.commons.spring.YamlPropertySourceFactory;
import cn.ponfee.commons.util.ObjectUtils;
import cn.ponfee.commons.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class YamlProperties
extends Properties
implements TypedMap<Object, Object> {
    private static final long serialVersionUID = -1599483902442715272L;

    public YamlProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.loadYaml(inputStream);
        }
    }

    public YamlProperties(InputStream inputStream) {
        this.loadYaml(inputStream);
    }

    public YamlProperties(byte[] content) {
        this.loadYaml(new ByteArrayInputStream(content));
    }

    public <T> T extract(Class<T> beanType, String prefix) {
        T bean = ClassUtils.newInstance(beanType);
        char[] separators = new char[]{'-', '.'};
        block0: for (Field field : ClassUtils.listFields(beanType)) {
            for (char separator : separators) {
                String name = prefix + Strings.toSeparatedName(field.getName(), separator);
                if (!super.containsKey(name)) continue;
                Fields.put(bean, field, ObjectUtils.cast(this.get(name), field.getType()));
                continue block0;
            }
        }
        return bean;
    }

    private void loadYaml(InputStream inputStream) {
        InputStreamResource resource = new InputStreamResource(inputStream);
        super.putAll((Map<?, ?>)YamlPropertySourceFactory.loadYml((Resource)resource));
    }
}

