/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.tree.print;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class BinaryTreePrinter<T> {
    private final Appendable output;
    private final Function<T, String> nodeLabel;
    private final Function<T, T> leftChild;
    private final Function<T, T> rightChild;
    private final Branch branch;
    private final boolean directed;
    private final int nodeSpace;
    private final int treeSpace;

    BinaryTreePrinter(Appendable output, Function<T, String> nodeLabel, Function<T, T> leftChild, Function<T, T> rightChild, Branch branch, boolean directed, int nodeSpace, int treeSpace) {
        this.output = output;
        this.nodeLabel = nodeLabel;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.branch = branch;
        this.directed = directed;
        this.nodeSpace = nodeSpace;
        this.treeSpace = Math.max(treeSpace / 2 * 2 + 1, 3);
    }

    public void print(T root) throws IOException {
        this.printTreeLines(this.buildTreeLines(root));
    }

    public void print(List<T> trees, int lineWidth) throws IOException {
        ArrayList<List<TreeLine>> allTreeLines = new ArrayList<List<TreeLine>>(trees.size());
        int[] treeWidths = new int[trees.size()];
        int[] minLeftOffsets = new int[trees.size()];
        int[] maxRightOffsets = new int[trees.size()];
        for (int i = 0; i < trees.size(); ++i) {
            List<TreeLine> treeLines = this.buildTreeLines(trees.get(i));
            allTreeLines.add(treeLines);
            minLeftOffsets[i] = BinaryTreePrinter.minLeftOffset(treeLines);
            maxRightOffsets[i] = BinaryTreePrinter.maxRightOffset(treeLines);
            treeWidths[i] = maxRightOffsets[i] - minLeftOffsets[i] + 1;
        }
        String halfTreeSpaceStr = BinaryTreePrinter.spaces(this.treeSpace / 2);
        int nextTreeIndex = 0;
        while (nextTreeIndex < trees.size()) {
            int endTreeIndex;
            int sumOfWidths = treeWidths[nextTreeIndex];
            for (endTreeIndex = nextTreeIndex + 1; endTreeIndex < trees.size() && sumOfWidths + this.treeSpace + treeWidths[endTreeIndex] < lineWidth; ++endTreeIndex) {
                sumOfWidths += this.treeSpace + treeWidths[endTreeIndex];
            }
            --endTreeIndex;
            int maxLines = allTreeLines.stream().mapToInt(List::size).max().orElse(0);
            for (int i = 0; i < maxLines; ++i) {
                for (int j = nextTreeIndex; j <= endTreeIndex; ++j) {
                    List treeLines = (List)allTreeLines.get(j);
                    if (i >= treeLines.size()) {
                        this.output.append(BinaryTreePrinter.spaces(treeWidths[j]));
                    } else {
                        int leftSpaces = -(minLeftOffsets[j] - ((TreeLine)treeLines.get((int)i)).leftOffset);
                        int rightSpaces = maxRightOffsets[j] - ((TreeLine)treeLines.get((int)i)).rightOffset;
                        this.output.append(BinaryTreePrinter.spaces(leftSpaces)).append(((TreeLine)treeLines.get((int)i)).line).append(BinaryTreePrinter.spaces(rightSpaces));
                    }
                    if (j >= endTreeIndex) continue;
                    this.output.append(halfTreeSpaceStr).append('|').append(halfTreeSpaceStr);
                }
                this.output.append("\n");
            }
            nextTreeIndex = endTreeIndex + 1;
        }
    }

    private void printTreeLines(List<TreeLine> treeLines) throws IOException {
        if (treeLines.size() <= 0) {
            return;
        }
        int minLeftOffset = BinaryTreePrinter.minLeftOffset(treeLines);
        int maxRightOffset = BinaryTreePrinter.maxRightOffset(treeLines);
        for (TreeLine treeLine : treeLines) {
            this.output.append(BinaryTreePrinter.spaces(-(minLeftOffset - treeLine.leftOffset))).append(treeLine.line).append(BinaryTreePrinter.spaces(maxRightOffset - treeLine.rightOffset)).append("\n");
        }
    }

    private List<TreeLine> buildTreeLines(T root) {
        int i;
        boolean hasRightTreeLines;
        if (root == null) {
            return Collections.emptyList();
        }
        String rootLabel = this.nodeLabel.apply(root);
        List<TreeLine> leftTreeLines = this.buildTreeLines(this.leftChild.apply(root));
        List<TreeLine> rightTreeLines = this.buildTreeLines(this.rightChild.apply(root));
        int leftCount = leftTreeLines.size();
        int rightCount = rightTreeLines.size();
        int minCount = Math.min(leftCount, rightCount);
        int maxCount = Math.max(leftCount, rightCount);
        int maxRootSpacing = 0;
        for (int i2 = 0; i2 < minCount; ++i2) {
            maxRootSpacing = Math.max(maxRootSpacing, leftTreeLines.get((int)i2).rightOffset - rightTreeLines.get((int)i2).leftOffset);
        }
        int rootSpacing = maxRootSpacing + this.nodeSpace;
        if ((rootSpacing & 1) == 0) {
            ++rootSpacing;
        }
        ArrayList<TreeLine> allTreeLines = new ArrayList<TreeLine>();
        String renderedRootLabel = rootLabel.replaceAll("\\e\\[[\\d;]*[^\\d;]", "");
        allTreeLines.add(new TreeLine(rootLabel, -(renderedRootLabel.length() - 1) / 2, renderedRootLabel.length() / 2));
        int leftTreeAdjust = 0;
        int rightTreeAdjust = 0;
        boolean hasLeftTreeLines = !leftTreeLines.isEmpty();
        boolean bl = hasRightTreeLines = !rightTreeLines.isEmpty();
        if (hasLeftTreeLines && hasRightTreeLines) {
            if (this.branch == Branch.RECTANGLE) {
                int adjust = rootSpacing / 2 + 1;
                String horizontal = String.join((CharSequence)"", Collections.nCopies(rootSpacing / 2, "\u2500"));
                String branch = "\u250c" + horizontal + "\u2534" + horizontal + "\u2510";
                allTreeLines.add(new TreeLine(branch, -adjust, adjust));
                rightTreeAdjust = adjust;
                leftTreeAdjust = -adjust;
            } else if (rootSpacing == 1) {
                allTreeLines.add(new TreeLine("/ \\", -1, 1));
                rightTreeAdjust = 2;
                leftTreeAdjust = -2;
            } else {
                for (i = 1; i < rootSpacing; i += 2) {
                    String branches = "/" + BinaryTreePrinter.spaces(i) + "\\";
                    allTreeLines.add(new TreeLine(branches, -((i + 1) / 2), (i + 1) / 2));
                }
                rightTreeAdjust = rootSpacing / 2 + 1;
                leftTreeAdjust = -(rootSpacing / 2 + 1);
            }
        } else if (hasLeftTreeLines) {
            if (this.branch == Branch.RECTANGLE) {
                if (this.directed) {
                    allTreeLines.add(new TreeLine("\u2502", 0, 0));
                } else {
                    allTreeLines.add(new TreeLine("\u250c\u2518", -1, 0));
                    leftTreeAdjust = -1;
                }
            } else {
                allTreeLines.add(new TreeLine("/", -1, -1));
                leftTreeAdjust = -2;
            }
        } else if (hasRightTreeLines) {
            if (this.branch == Branch.RECTANGLE) {
                if (this.directed) {
                    allTreeLines.add(new TreeLine("\u2502", 0, 0));
                } else {
                    allTreeLines.add(new TreeLine("\u2514\u2510", 0, 1));
                    rightTreeAdjust = 1;
                }
            } else {
                allTreeLines.add(new TreeLine("\\", 1, 1));
                rightTreeAdjust = 2;
            }
        }
        for (i = 0; i < maxCount; ++i) {
            TreeLine left;
            TreeLine right;
            if (i >= leftTreeLines.size()) {
                right = rightTreeLines.get(i);
                right.leftOffset += rightTreeAdjust;
                right.rightOffset += rightTreeAdjust;
                allTreeLines.add(right);
                continue;
            }
            if (i >= rightTreeLines.size()) {
                left = leftTreeLines.get(i);
                left.leftOffset += leftTreeAdjust;
                left.rightOffset += leftTreeAdjust;
                allTreeLines.add(left);
                continue;
            }
            left = leftTreeLines.get(i);
            right = rightTreeLines.get(i);
            int adjustedRootSpacing = rootSpacing == 1 ? (this.branch == Branch.RECTANGLE ? 1 : 3) : rootSpacing;
            TreeLine combined = new TreeLine(left.line + BinaryTreePrinter.spaces(adjustedRootSpacing - left.rightOffset + right.leftOffset) + right.line, left.leftOffset + leftTreeAdjust, right.rightOffset + rightTreeAdjust);
            allTreeLines.add(combined);
        }
        return allTreeLines;
    }

    private static int minLeftOffset(List<TreeLine> treeLines) {
        return treeLines.stream().mapToInt(e -> e.leftOffset).min().orElse(0);
    }

    private static int maxRightOffset(List<TreeLine> treeLines) {
        return treeLines.stream().mapToInt(e -> e.rightOffset).max().orElse(0);
    }

    private static String spaces(int n) {
        return Strings.repeat((String)" ", (int)n);
    }

    private static class TreeLine {
        final String line;
        int leftOffset;
        int rightOffset;

        TreeLine(String line, int leftOffset, int rightOffset) {
            this.line = line;
            this.leftOffset = leftOffset;
            this.rightOffset = rightOffset;
        }
    }

    public static enum Branch {
        RECTANGLE,
        TRIANGLE;

    }
}

