/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.tree.print;

import cn.ponfee.commons.base.tuple.Tuple4;
import cn.ponfee.commons.collect.Collects;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public final class MultiwayTreePrinter<T> {
    private final Appendable output;
    private final Function<T, CharSequence> nodeLabel;
    private final Function<T, List<T>> nodeChildren;

    public MultiwayTreePrinter(Appendable output, Function<T, CharSequence> nodeLabel, Function<T, List<T>> nodeChildren) {
        this.output = output;
        this.nodeLabel = nodeLabel;
        this.nodeChildren = nodeChildren;
    }

    public void print(T root) throws IOException {
        LinkedList<Tuple4<String, String, String, T>> stack = Collects.newLinkedList(Tuple4.of("", "", "", root));
        while (!stack.isEmpty()) {
            Tuple4 tuple = (Tuple4)stack.pop();
            this.output.append((CharSequence)tuple.a).append((CharSequence)tuple.c).append(this.nodeLabel.apply(tuple.d)).append('\n');
            List<T> children = this.nodeChildren.apply(tuple.d);
            if (children == null || children.isEmpty()) continue;
            String a = ((String)tuple.b).isEmpty() ? (String)tuple.a : (String)tuple.a + (String)tuple.b;
            int index = 0;
            for (Object child : Lists.reverse(children)) {
                if (index++ == 0) {
                    stack.push(Tuple4.of(a, "    ", "\u2514\u2500\u2500 ", child));
                    continue;
                }
                stack.push(Tuple4.of(a, "\u2502   ", "\u251c\u2500\u2500 ", child));
            }
        }
    }
}

