/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.commons.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Holder<T> {
    private T value;

    private Holder(T value) {
        this.value = value;
    }

    public static <T> Holder<T> empty() {
        return new Holder<Object>(null);
    }

    public static <T> Holder<T> of(T value) {
        return new Holder<T>(value);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public T set(T value) {
        T former = this.value;
        this.value = value;
        return former;
    }

    public void setIfAbsent(T value) {
        if (this.value == null) {
            this.value = value;
        }
    }

    public T setIfPresent(T value) {
        T former = this.value;
        if (this.value != null) {
            this.value = value;
        }
        return former;
    }

    public T setIfMatches(T value, Predicate<T> predicate) {
        T former = this.value;
        if (predicate.test(this.value)) {
            this.value = value;
        }
        return former;
    }

    public T setIfMatches(T value, BiPredicate<T, T> predicate) {
        T former = this.value;
        if (predicate.test(this.value, value)) {
            this.value = value;
        }
        return former;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public <U> Holder<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isEmpty() ? Holder.empty() : Holder.of(mapper.apply(this.value));
    }

    public Holder<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.isEmpty() || predicate.test(this.value) ? this : Holder.empty();
    }

    public T get() {
        return this.value;
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<T> other) {
        return this.value != null ? this.value : other.get();
    }

    public <E extends Throwable> T orElseThrow(Supplier<? extends E> exceptionSupplier) throws E {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Holder && Objects.equals(this.value, ((Holder)obj).value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("Holder(%s)", this.value) : "Holder.empty";
    }
}

